package com.biz.crm.order;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.base.CrmFileEntity;
import com.biz.crm.sqlupdate.CrmColumn;
import com.biz.crm.sqlupdate.CrmTable;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import javax.persistence.Index;


/**
 * @Description:
 * @Author: zhangyuzhu
 * @Date: 2021/1/28 15:13
 **/
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
@TableName("dms_order_file")
@CrmTable(name = "dms_order_file", indexes = {
        @Index(name = "index_order_file_order_code", columnList = "order_code")
},tableNote = "订单文件")
public class OrderFileEntity extends CrmFileEntity<OrderFileEntity> {

    /**
     * 订单编码
     */
    @CrmColumn(name = "order_code", length = 64)
    private String orderCode;

}
