package com.biz.crm.order;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.base.CrmBaseEntity;
import com.biz.crm.sqlupdate.CrmColumn;
import com.biz.crm.sqlupdate.CrmTable;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.math.BigDecimal;


/**
 * @Description:
 * @Author: zhangyuzhu
 * @Date: 2021/1/27 16:49
 **/
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
@TableName("dms_order_detail_promotion")
@CrmTable(name = "dms_order_detail_promotion",tableNote = "订单对应促销信息")
public class OrderDetailPromotionEntity extends CrmBaseEntity<OrderDetailPromotionEntity> {

    /**
     * 订单Code
     */
    @CrmColumn(name = "order_code", length = 64)
    private String orderCode;

    /**
     * 订单行号
     */
    @CrmColumn(name = "order_detail_line_no", length = 64)
    private String orderDetailLineNo;

    /**
     * 促销code
     */
    @CrmColumn(name = "promotion_code", length = 64)
    private String promotionCode;

    /**
     * 促销名称
     */
    @CrmColumn(name = "promotion_name", length = 100)
    private String promotionName;

    /**
     * 促销Id
     */
    @CrmColumn(name = "promotion_id", length = 64)
    private String promotionId;

    /**
     * 促销类型
     */
    @CrmColumn(name = "promotion_type", length = 16)
    private String promotionType;

    /**
     * 促销金额
     */
    @CrmColumn(name = "promotion_amount",mysqlType = "decimal(16,6)",oracleType = "NUMBER(16, 6)")
    private BigDecimal promotionAmount;

    /**
     * 促销计算描述
     */
    @CrmColumn(name = "promotion_des", length = 254)
    private String promotionDes;

    /**
     * 促销计算顺序
     */
    @CrmColumn(name = "sort_num",mysqlType = "decimal(16,6)",oracleType = "NUMBER(16, 6)")
    private Integer sortNum;

    /**
     * 是否组合
     */
    @CrmColumn(name = "combination_flag", length = 254)
    private String combinationFlag;
}
