package com.biz.crm.order;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.base.CrmExtEntity;
import com.biz.crm.sqlupdate.CrmColumn;
import com.biz.crm.sqlupdate.CrmTable;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.math.BigDecimal;

/**
 * @Description:
 * @Author: zhangyuzhu
 * @Date: 2021/1/27 16:49
 **/
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
@TableName("dms_order")
@CrmTable(name = "dms_order")
public class OrderEntity extends CrmExtEntity<OrderEntity> {

    //------------------订单基本信息----------------------
    /**
     * 订单来源 dms_order_source
     */
    @CrmColumn(name = "from_type", length = 64)
    private String fromType;
    /**
     * 订单编号(额外标记)
     */
    @CrmColumn(name = "order_code", length = 64, unique = true)
    private String orderCode;

    /**
     * 销售订单编号
     */
    @CrmColumn(name = "order_sales_code", length = 64, unique = true)
    private String orderSalesCode;


    /**
     * 订单来源编号
     */
    @CrmColumn(name = "source_code", length = 64)
    private String sourceCode;

    /**
     * 订单类型(dms_order_type)
     */
    @CrmColumn(name = "type", length = 64)
    private String type;

    /**
     * 订单状态(dms_order_state)
     */
    @CrmColumn(name = "state", length = 64)
    private String state;

    /**
     * 是否是暂存订单(yesOrNo)
     */
    @CrmColumn(name = "temporary_flag",length = 8)
    private String temporaryFlag;

    //--------------------订单商品相关信息------------------------

    /**
     * 订单总重量(克)
     */
    @CrmColumn(name = "weight_of_gram",mysqlType = "decimal(16,6)",oracleType = "NUMBER(16, 6)")
    private BigDecimal weightOfGram;

    /**
     * 订单总重量(千克)
     */
    @CrmColumn(name = "weight_of_kilogram",mysqlType = "decimal(16,6)",oracleType = "NUMBER(16, 6)")
    private BigDecimal weightOfKilogram;

    /**
     * 订单总重量(吨)
     */
    @CrmColumn(name = "weight_of_ton",mysqlType = "decimal(16,6)",oracleType = "NUMBER(16, 6)")
    private BigDecimal weightOfTon;

    /**
     * 商品总数量
     */
    @CrmColumn(name = "product_num",mysqlType = "decimal(16,6)",oracleType = "NUMBER(16, 6)")
    private BigDecimal productNum;

    //--------------------------订单金额---------------------------------

    /**
     * 订单总金额
     */
    @CrmColumn(name = "amount",mysqlType = "decimal(16,6)",oracleType = "NUMBER(16, 6)")
    private BigDecimal amount;

    /**
     * 订单促销优惠金额
     */
    @CrmColumn(name = "promotion_amount",mysqlType = "decimal(16,6)",oracleType = "NUMBER(16, 6)")
    private BigDecimal promotionAmount;

    /**
     * 订单折扣费用使用金额
     */
    @CrmColumn(name = "discount_amount",mysqlType = "decimal(16,6)",oracleType = "NUMBER(16, 6)")
    private BigDecimal discountAmount;

    /**
     * 订单折扣费用最大使用金额计算过程
     */
    @CrmColumn(name = "max_discount_amount_des", length = 256)
    private String maxDiscountAmountDes;

    /**
     * 订单货补费用使用金额
     */
    @CrmColumn(name = "rep_amount",mysqlType = "decimal(16,6)",oracleType = "NUMBER(16, 6)")
    private BigDecimal repAmount;

    /**
     * 实际支付金额
     */
    @CrmColumn(name = "actual_amount",mysqlType = "decimal(16,6)",oracleType = "NUMBER(16, 6)")
    private BigDecimal actualAmount;

    //-------------------------交货信息---------------------------

    /**
     * 提货方式(dms_order_pick_type)
     */
    @CrmColumn(name = "pick_type", length = 64)
    private String pickType;

    /**
     * 收货地址
     */
    @CrmColumn(name = "pick_adress", length = 100)
    private String pickAdress;

    /**
     * 联系人姓名
     */
    @CrmColumn(name = "contacts_name", length = 100)
    private String contactsName;

    /**
     * 联系人电话
     */
    @CrmColumn(name = "contacts_phone", length = 16)
    private String contactsPhone;

    /**
     * 交货日期(yyyy-MM-dd HH:mm:ss)
     */
    @CrmColumn(name = "give_date", length = 20)
    private String giveDate;


    //----------------------客户信息-------------------------

    /**
     * 客户编码
     */
    @CrmColumn(name = "cus_code", length = 64)
    private String cusCode;

    /**
     * 客户sap编码
     */
    @CrmColumn(name = "cus_sap_code", length = 64)
    private String cusSapCode;

    /**
     * 客户名称
     */
    @CrmColumn(name = "cus_name", length = 100)
    private String cusName;

    /**
     * 客户组织编码
     */
    @CrmColumn(name = "cus_org_code", length = 64)
    private String cusOrgCode;

    /**
     * 客户组织名称
     */
    @CrmColumn(name = "cus_org_name", length = 100)
    private String cusOrgName;

    /**
     * 客户所属公司编码
     */
    @CrmColumn(name = "company_code", length = 64)
    private String companyCode ;

    /**
     * 客户所属公司名称
     */
    @CrmColumn(name = "company_name", length = 100)
    private String companyName;

    /**
     * 终端编码
     */
    @CrmColumn(name = "terminal_code", length = 64)
    private String terminalCode;

    /**
     * 终端名称
     */
    @CrmColumn(name = "terminal_name", length = 100)
    private String terminalName;

    /**
     * 送达方编码
     */
    @CrmColumn(name = "delivery_code", length = 100)
    private String deliveryCode;


    //---------------流程-----------------------------------------------------------------
    /**
     * 工作流key
     */
    @CrmColumn(name = "work_flow_key", length = 32,note = "工作流key")
    private String workFlowKey;

    /**
     * 工作流名称
     */
    @CrmColumn(name = "work_flow_name", length = 60,note = "工作流名称")
    private String workFlowName;

    /**
     * 工作流名称
     */
    @CrmColumn(name = "audit_state", length = 32,note = "审核状态")
    private String auditState;

    /**
     * 流程编号
     */
    @CrmColumn(name = "process_code", length = 32,note = "流程编号")
    private String processCode;


    @CrmColumn(name = "erp_status", length = 10,note = "ERP订单状态")
    private String erpStatus;

}
