package com.biz.crm.order.tools.strategy.ordervalidateparam.impl;

import com.biz.crm.base.BusinessException;
import com.biz.crm.nebular.order.OrderDetailVo;
import com.biz.crm.nebular.order.OrderGroupItemVo;
import com.biz.crm.nebular.order.OrderVo;
import com.biz.crm.order.tools.strategy.ordervalidateparam.OrderValidateParamStrategy;
import com.biz.crm.util.ValidateUtils;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

import java.util.List;

/**
 * @Description: 免费订单入参验证策略类
 * @Author: zhangyuzhu
 * @Date: 2021/3/16 16:59
 **/
@ConditionalOnMissingBean(name = "freeOrderValidateParamStrategyExpand")
@Component("freeOrderValidateParamStrategy")
public class FreeOrderValidateParamStrategy implements OrderValidateParamStrategy {


    @Override
    public void validate(OrderVo orderVo, Object... objects) {
        ValidateUtils.validate(orderVo.getCusCode(),"请先选择经销商!");
        //验证本品和赠品数据
        if(CollectionUtils.isEmpty(orderVo.getGroupItemVos())){
            throw new BusinessException("商品信息为空!");
        }
        for(OrderGroupItemVo groupItemVo : orderVo.getGroupItemVos()){
            if(CollectionUtils.isEmpty(groupItemVo.getNormalList())){
                throw new BusinessException("错误订单，请检查!");
            }
            validateForDetail(groupItemVo.getNormalList(),objects);
        }
    }

    /**
     * 验证商品必须信息
     * @param list
     */
    public static void validateForDetail(List<OrderDetailVo> list,Object... objects){
        if(CollectionUtils.isEmpty(list)){
            return;
        }
        for(OrderDetailVo item : list){
            ValidateUtils.validate(item.getProductCode(),"商品编码为空!");
            ValidateUtils.validate(item.getProductNum(),"商品数量为空!");
        }
    }


}
