package com.biz.crm.order.tools.strategy.ordervalidateparam.impl;

import com.biz.crm.base.BusinessException;
import com.biz.crm.eunm.YesNoEnum;
import com.biz.crm.eunm.dms.OrderEunm;
import com.biz.crm.nebular.order.OrderDetailPromotionVo;
import com.biz.crm.nebular.order.OrderDetailVo;
import com.biz.crm.nebular.order.OrderGroupItemVo;
import com.biz.crm.nebular.order.OrderVo;
import com.biz.crm.order.tools.strategy.ordervalidateparam.OrderValidateParamStrategy;
import com.biz.crm.util.StringUtils;
import com.biz.crm.util.ValidateUtils;
import java.util.Objects;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;

/**
 * @Description: 标准订单入参验证策略类
 * @Author: zhangyuzhu
 * @Date: 2021/3/16 16:59
 **/
@ConditionalOnMissingBean(name = "standerdOrderValidateParamStrategyExpand")
@Component("standerdOrderValidateParamStrategy")
public class StanderdOrderValidateParamStrategy implements OrderValidateParamStrategy {

    /**
     * 1、验证
     * 2、将组上促销价格置零
     * 3、重置算价成功标记
     * @param orderVo
     * @param objects 额外参数，用作拓展
     */
    @Override
    public void validate(OrderVo orderVo, Object... objects) {
        //1
        ValidateUtils.validate(orderVo.getCusCode(), "请先选择经销商!");
        //验证本品和赠品数据
        if (CollectionUtils.isEmpty(orderVo.getGroupItemVos())) {
            throw new BusinessException("商品信息为空!");
        }
        for (OrderGroupItemVo groupItemVo : orderVo.getGroupItemVos()) {
            //初始化所有的块算价成功标记
            groupItemVo.setCalSucessFlag(YesNoEnum.yesNoEnum.YES.getValue());
            //重置算价成功标记
            groupItemVo.setPromotionAmount(BigDecimal.ZERO);
            if(StringUtils.isEmpty(groupItemVo.getBuyAndGiveFlag())){
                throw new BusinessException("错误订单，请检查!");
            }
            if (CollectionUtils.isEmpty(groupItemVo.getBackList())
                    && CollectionUtils.isEmpty(groupItemVo.getNormalList())) {
                throw new BusinessException("错误订单，请检查!");
            }
            validateForDetail(groupItemVo.getBackList(),objects);
            groupItemVo.getGiftList().forEach(item -> item.setLineType(OrderEunm.LineTypeEnum.GIFT_PRODUCT.getCode()));
            validateForDetail(groupItemVo.getGiftList(),objects);
            validateForDetail(groupItemVo.getNormalList(),objects);

            validatePromotionBlock(groupItemVo);
        }
    }

    /**
     * 验证商品必须信息
     * @param list
     */
    public static void validateForDetail(List<OrderDetailVo> list,Object... objects){
        if(CollectionUtils.isEmpty(list)){
            return;
        }
        for(OrderDetailVo item : list){
            //初始化所有的行算价成功标记
            item.setCalSucessFlag(YesNoEnum.yesNoEnum.YES.getValue());
            ValidateUtils.validate(item.getProductCode(),"商品编码为空!");
            if(!Objects.equals(OrderEunm.LineTypeEnum.GIFT_PRODUCT.getCode(), item.getLineType())) {
                ValidateUtils.validate(item.getProductNum(),"商品数量为空!");
            }
            validatePromotion(item.getPromotionVos());
        }
    }

    /**
     * 验证促销信息(设置促销返回y)
     * @param promotionVos
     */
   public static void validatePromotion(ArrayList<OrderDetailPromotionVo> promotionVos){
        if(CollectionUtils.isEmpty(promotionVos)){
            return;
        }
        for(OrderDetailPromotionVo promotion : promotionVos){
            promotion.setCalSucessFlag(YesNoEnum.yesNoEnum.YES.getValue());
            ValidateUtils.validate(promotion.getPromotionCode(),"促销编码为空!");
            ValidateUtils.validate(promotion.getPromotionName(),"促销名称为空!");
            ValidateUtils.validate(promotion.getPromotionType(),"促销类型为空!");
        }
   }


    /**
     * 验证块上的促销
     * 块上的促销必须是买赠（这点在促销步骤里面验证）
     * 块里面只有一个买赠促销，并且必须和块上面定义的促销一样
     * @param groupItemVo
     */
   public static void validatePromotionBlock(OrderGroupItemVo groupItemVo){
       if(groupItemVo.getBuyAndGiveFlag().equals(YesNoEnum.yesNoEnum.NO.getValue())){
           return;
       }
       ValidateUtils.validate(groupItemVo.getPromotionCode(),"块促销类型为空!");
       for(OrderDetailVo item : groupItemVo.getNormalList()){
           if(CollectionUtils.isEmpty(item.getPromotionVos())){
               continue;
           }
           for(OrderDetailPromotionVo promotionVo : item.getPromotionVos()){
               if(promotionVo.getPromotionCode().equals(groupItemVo.getPromotionCode())){
                   return;
               }
           }
       }
       throw new BusinessException("错误订单，请检查!");
   }


}
