package com.biz.crm.order.tools.strategy.validaterebate.impl;

import com.biz.crm.base.BusinessException;
import com.biz.crm.eunm.YesNoEnum;
import com.biz.crm.eunm.dms.OrderEunm;
import com.biz.crm.fee.pool.FeePoolFeign;
import com.biz.crm.nebular.order.OrderDetailVo;
import com.biz.crm.nebular.order.OrderGroupItemVo;
import com.biz.crm.nebular.order.OrderVo;
import com.biz.crm.nebular.fee.pool.req.FeePoolAmountQueryReqVo;
import com.biz.crm.nebular.fee.pool.resp.FeePoolAmountQueryRespVo;
import com.biz.crm.order.tools.strategy.validaterebate.ValidateRebateFeeStrategy;
import com.biz.crm.util.Result;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

/**
 * @Description: 货补订单验证策略
 * @Author: zhangyuzhu
 * @Date: 2021/3/16 19:20
 **/
@ConditionalOnMissingBean(name = "rebateOrderValidateFeeStategyExpand")
@Component("rebateOrderValidateFeeStategy")
public class RebateOrderValidateFeeStategy implements ValidateRebateFeeStrategy {

    @Autowired
    private FeePoolFeign feePoolFeign;

    /**
     * @param orderVo
     * @param cusCode
     * @param orgCode
     * @param objects
     * @return
     */
    @Override
    public OrderVo validate(OrderVo orderVo, String cusCode, String orgCode, Object... objects) {
        FeePoolAmountQueryReqVo feePoolAmountQueryReqVo = this.packageFeeParam(orderVo,cusCode);
        Result<FeePoolAmountQueryRespVo> result =feePoolFeign.queryPoolAmount(feePoolAmountQueryReqVo);
        if(!result.isSuccess()){
            throw new BusinessException("费用服务正在重启，请联系管理员");
        }
        FeePoolAmountQueryRespVo feePoolAmountQueryRespVo = result.getResult();
        orderVo = this.calRapFromFee(orderVo,feePoolAmountQueryRespVo.getPoolUsableAmountMap());
        return orderVo;
    }


    /**
     * 从费用池验证费用是否足够
     * @param orderVo
     * @param poolMap
     * @return
     */
    public OrderVo calRapFromFee(OrderVo orderVo, Map<String, BigDecimal> poolMap){
        for(OrderGroupItemVo groupItemVo : orderVo.getGroupItemVos()){
            if(!CollectionUtils.isEmpty(groupItemVo.getBackList())){
                for(OrderDetailVo itemVo : groupItemVo.getBackList()){
                    BigDecimal ableFee = poolMap.get(itemVo.getFeeCode());
                    if(null == ableFee){
                        orderVo.setCalSucessFlag(YesNoEnum.yesNoEnum.NO.getValue());
                        orderVo.setCalSucessMsgType(OrderEunm.calSucessMsgTypeEnum.LINE.getCode());
                        itemVo.setCalSucessFlag(YesNoEnum.yesNoEnum.NO.getValue());
                        StringBuilder stb = new StringBuilder("提示：货补商品【")
                                .append(itemVo.getProductName())
                                .append("】对应的费用【")
                                .append(itemVo.getFeeName())
                                .append("】剩余为0,请重新选择");
                        itemVo.setCalSucessMsg(stb.toString());
                        continue;
                    }
                    if(itemVo.getAmount().compareTo(ableFee) > 0){
                        orderVo.setCalSucessFlag(YesNoEnum.yesNoEnum.NO.getValue());
                        orderVo.setCalSucessMsgType(OrderEunm.calSucessMsgTypeEnum.LINE.getCode());
                        itemVo.setCalSucessFlag(YesNoEnum.yesNoEnum.NO.getValue());
                        StringBuilder stb = new StringBuilder("提示：货补商品【")
                                .append(itemVo.getProductName())
                                .append("】已超过费用【")
                                .append(itemVo.getFeeName())
                                .append("】的最大限额")
                                .append(ableFee)
                                .append("元】,请调整数量或者加大商品购买量！");
                        itemVo.setCalSucessMsg(stb.toString());
                    }
                }
            }
        }
        return orderVo;
    }


    /**
     * 组装费用查询参数
     * @param orderVo
     * @param cusCode
     * @return
     */
    public FeePoolAmountQueryReqVo packageFeeParam(OrderVo orderVo,String cusCode){
        FeePoolAmountQueryReqVo vo = new FeePoolAmountQueryReqVo();
        vo.setCustomerCode(cusCode);
        List<String> poolCodeList = new ArrayList<>();
        for(OrderGroupItemVo groupItemVo : orderVo.getGroupItemVos()){
            if(!CollectionUtils.isEmpty(groupItemVo.getBackList())){
                for(OrderDetailVo itemVo : groupItemVo.getBackList()){
                    poolCodeList.add(itemVo.getFeeCode());
                }
            }
        }
        vo.setPoolCodeList(poolCodeList);
        return vo;
    }

}
