package com.biz.crm.order.utils;

import com.biz.crm.nebular.order.OrderDetailPromotionVo;
import com.biz.crm.order.OrderDetailPromotionEntity;
import com.biz.crm.order.OrderEntity;
import org.springframework.beans.BeanUtils;
import org.springframework.util.CollectionUtils;

import java.util.ArrayList;
import java.util.List;

/**
 * @Description:
 * @Author: zhangyuzhu
 * @Date: 2021/5/11 11:29
 **/
public class OrderDetailPromotionUtil {

    /**
     * 模型转换
     * @param orderEntity
     * @param promotionVos
     */
    public static List<OrderDetailPromotionEntity> packageEntity(OrderEntity orderEntity, List<OrderDetailPromotionVo> promotionVos){
        if(CollectionUtils.isEmpty(promotionVos)){
            return new ArrayList<>();
        }
        List<OrderDetailPromotionEntity> reList = new ArrayList<>(promotionVos.size());
        for(OrderDetailPromotionVo vo : promotionVos){
            OrderDetailPromotionEntity entity = new OrderDetailPromotionEntity();
            BeanUtils.copyProperties(vo,entity);
            entity.setOrderCode(orderEntity.getOrderCode());
            reList.add(entity);
        }
        return reList;
    }

    /**
     * 模型转换
     * @param entities
     * @return
     */
    public static List<OrderDetailPromotionVo> packageVo(List<OrderDetailPromotionEntity> entities){
        List<OrderDetailPromotionVo> reList = new ArrayList<>(entities.size());
        for(OrderDetailPromotionEntity entity : entities){
            OrderDetailPromotionVo vo  = new OrderDetailPromotionVo();
            BeanUtils.copyProperties(entity,vo);
            reList.add(vo);
        }
        return reList;
    }
}
