/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.order.tools.handler;

import com.biz.crm.base.BusinessException;
import com.biz.crm.eunm.dms.OrderEunm;
import com.biz.crm.eunm.fee.FeePoolOperationTypeEnum;
import com.biz.crm.fee.pool.FeePoolFeign;
import com.biz.crm.nebular.fee.pool.req.FeePoolDiscountUseReqVo;
import com.biz.crm.nebular.fee.pool.req.FeePoolGoodsUseByPoolProductItemReqVo;
import com.biz.crm.nebular.fee.pool.req.FeePoolGoodsUseReqVo;
import com.biz.crm.nebular.fee.pool.req.FeePoolUseReqVo;
import com.biz.crm.order.OrderDetailEntity;
import com.biz.crm.order.OrderEntity;
import com.biz.crm.util.Result;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@ConditionalOnMissingBean(name={"orderUseFeeHandlerExpand"})
@Component(value="orderUseFeeHandler")
public class OrderUseFeeHandler {
    @Autowired
    private FeePoolFeign feePoolFeign;

    public void hand(OrderEntity orderEntity, List<OrderDetailEntity> detailEntities) {
        FeePoolUseReqVo feeUseParam = this.packageFeeUseParam(orderEntity, detailEntities);
        Result result = this.feePoolFeign.usePool(feeUseParam);
        if (!result.isSuccess()) {
            throw new BusinessException(result.getMessage());
        }
    }

    public FeePoolUseReqVo packageFeeUseParam(OrderEntity entity, List<OrderDetailEntity> detailEntities) {
        FeePoolUseReqVo feePoolUseReqVo = new FeePoolUseReqVo();
        feePoolUseReqVo.setCustomerCode(entity.getCusCode());
        feePoolUseReqVo.setOperationType(FeePoolOperationTypeEnum.ORDER_USE.getValue());
        feePoolUseReqVo.setFromCode(entity.getOrderCode());
        FeePoolDiscountUseReqVo feePoolDiscountUseReqVo = new FeePoolDiscountUseReqVo();
        feePoolDiscountUseReqVo.setAmount(entity.getDiscountAmount());
        feePoolUseReqVo.setDiscount(feePoolDiscountUseReqVo);
        FeePoolGoodsUseReqVo feePoolGoodsUseReqVo = new FeePoolGoodsUseReqVo();
        ArrayList<FeePoolGoodsUseByPoolProductItemReqVo> poolProductAmountList = new ArrayList<FeePoolGoodsUseByPoolProductItemReqVo>();
        if (!CollectionUtils.isEmpty(detailEntities)) {
            for (OrderDetailEntity detail : detailEntities) {
                if (!detail.getLineType().equals(OrderEunm.LineTypeEnum.REP_PRODUCT.getCode())) continue;
                FeePoolGoodsUseByPoolProductItemReqVo feePoolGoodsUseItemReqVo = new FeePoolGoodsUseByPoolProductItemReqVo();
                feePoolGoodsUseItemReqVo.setAmount(detail.getAmount());
                feePoolGoodsUseItemReqVo.setPoolCode(detail.getFeeCode());
                feePoolGoodsUseItemReqVo.setProductCode(detail.getProductCode());
                poolProductAmountList.add(feePoolGoodsUseItemReqVo);
            }
        }
        feePoolGoodsUseReqVo.setGoodsUseByPoolProductList(poolProductAmountList);
        feePoolUseReqVo.setGoods(feePoolGoodsUseReqVo);
        return feePoolUseReqVo;
    }
}

