/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.order.tools.strategy.calpromotion.impl;

import com.biz.crm.base.BusinessException;
import com.biz.crm.dms.promotion.PromotionV2Feign;
import com.biz.crm.eunm.YesNoEnum;
import com.biz.crm.eunm.dms.OrderEunm;
import com.biz.crm.eunm.dms.PromotionPolicyEunm;
import com.biz.crm.nebular.dms.npromotion.vo.PromotionEditVo;
import com.biz.crm.nebular.dms.npromotion.vo.PromotionQueryReq;
import com.biz.crm.nebular.dms.npromotion.vo.PromotionSaleProductVo;
import com.biz.crm.nebular.order.OrderDetailPromotionVo;
import com.biz.crm.nebular.order.OrderDetailVo;
import com.biz.crm.nebular.order.OrderGroupItemVo;
import com.biz.crm.nebular.order.OrderVo;
import com.biz.crm.order.tools.strategy.calpromotion.CalPromotionStrategy;
import com.biz.crm.order.utils.OrderUtil;
import com.biz.crm.util.Result;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@ConditionalOnMissingBean(name={"fullReductionCalPromotionStrategyExpand"})
@Component(value="fullReductionCalPromotionStrategy")
public class FullReductionCalPromotionStrategy
implements CalPromotionStrategy {
    @Autowired
    private PromotionV2Feign promotionV2Feign;

    @Override
    public OrderVo cal(OrderVo orderVo, String cusCode, String orgCode, Integer calNum, Object ... objects) {
        ArrayList<PromotionQueryReq> param = FullReductionCalPromotionStrategy.packageParam(orderVo, cusCode, orgCode, objects);
        if (CollectionUtils.isEmpty(param)) {
            return orderVo;
        }
        Result result = this.promotionV2Feign.findHitPromotionMapByPromotionCodes(param);
        if (!result.isSuccess()) {
            throw new BusinessException("\u4fc3\u9500\u670d\u52a1\u6b63\u5728\u91cd\u542f\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458");
        }
        Map promotionMap = (Map)result.getResult();
        return FullReductionCalPromotionStrategy.cal(orderVo, promotionMap, calNum);
    }

    public static OrderVo cal(OrderVo orderVo, Map<String, PromotionEditVo> promotionMap, Integer calNum) {
        for (OrderGroupItemVo group : orderVo.getGroupItemVos()) {
            FullReductionCalPromotionStrategy.calPrice(orderVo, group, promotionMap, calNum);
            if (OrderUtil.judegeOrder(orderVo)) continue;
            return orderVo;
        }
        return orderVo;
    }

    public static void calPrice(OrderVo orderVo, OrderGroupItemVo group, Map<String, PromotionEditVo> promotionMap, Integer calNum) {
        BigDecimal promotionAmount = BigDecimal.ZERO;
        for (OrderDetailVo detail : group.getNormalList()) {
            if (CollectionUtils.isEmpty((Collection)detail.getPromotionVos())) continue;
            for (OrderDetailPromotionVo promotion : detail.getPromotionVos()) {
                if (!promotion.getPromotionType().equals(PromotionPolicyEunm.PromotionTypeEunm.FULLREDUCTION.getCode())) continue;
                PromotionEditVo promotionEditVo = promotionMap.get(promotion.getPromotionCode());
                if (null == promotionEditVo) {
                    orderVo.setCalSucessFlag(YesNoEnum.yesNoEnum.NO.getValue());
                    orderVo.setCalSucessMsgType(OrderEunm.calSucessMsgTypeEnum.PROMOTION.getCode());
                    FullReductionCalPromotionStrategy.zPromotionExsitError(group, promotion.getPromotionCode());
                    return;
                }
                if (FullReductionCalPromotionStrategy.judegeNum(group, promotionEditVo.getPromotionPolicyCode(), promotionEditVo)) {
                    orderVo.setCalSucessFlag(YesNoEnum.yesNoEnum.NO.getValue());
                    orderVo.setCalSucessMsgType(OrderEunm.calSucessMsgTypeEnum.LINE.getCode());
                    return;
                }
                if (!promotionEditVo.isMatchState()) {
                    orderVo.setCalSucessFlag(YesNoEnum.yesNoEnum.NO.getValue());
                    orderVo.setCalSucessMsgType(OrderEunm.calSucessMsgTypeEnum.PROMOTION.getCode());
                    FullReductionCalPromotionStrategy.zPromotionError(group, promotionEditVo);
                    return;
                }
                promotion.setPromotionName(promotionEditVo.getPromotionPolicyName());
                promotion.setPromotionType(promotionEditVo.getPromotionType());
                promotion.setPromotionPolicyId(promotionEditVo.getId());
                promotion.setSortNum(calNum);
                StringBuilder promotionMsg = new StringBuilder();
                BigDecimal oldAmount = detail.getAmount();
                detail.setAmount(detail.getAmount().subtract(promotionEditVo.getCalculateHitResultVo().getValue()).setScale(6, 4));
                promotionAmount = promotionAmount.add(promotionEditVo.getCalculateHitResultVo().getValue());
                promotionMsg.append("\u539f\u603b\u4ef7\u3010").append(oldAmount).append("\u3011").append("- \u6ee1\u51cf\u4ef7\u683c\u3010").append(promotionEditVo.getCalculateHitResultVo().getValue()).append("\u3011\u56db\u820d\u4e94\u5165\u540e =").append(detail.getAmount());
                promotion.setPromotionDes(promotionMsg.toString());
                promotion.setPromotionAmount(promotionEditVo.getCalculateHitResultVo().getValue());
            }
        }
        if (group.getPromotionAmount() == null) {
            group.setPromotionAmount(BigDecimal.ZERO);
        }
        group.setPromotionAmount(group.getPromotionAmount().add(promotionAmount));
    }

    public static void zPromotionError(OrderGroupItemVo group, PromotionEditVo promotionEditVo) {
        if (CollectionUtils.isEmpty((Collection)group.getNormalList())) {
            return;
        }
        for (OrderDetailVo detail : group.getNormalList()) {
            if (CollectionUtils.isEmpty((Collection)detail.getPromotionVos())) continue;
            for (OrderDetailPromotionVo promotionVo : detail.getPromotionVos()) {
                if (!promotionEditVo.getPromotionPolicyCode().equals(promotionVo.getPromotionCode())) continue;
                promotionVo.setCalSucessFlag(YesNoEnum.yesNoEnum.NO.getValue());
                StringBuilder stb = new StringBuilder("\u63d0\u793a\uff1a\u4fc3\u9500\u3010").append(group.getPromotionName()).append("\u3011 ").append(promotionEditVo.getMatchMsg());
                promotionVo.setCalSucessMsg(stb.toString());
            }
        }
    }

    public static void zPromotionExsitError(OrderGroupItemVo group, String promotionCode) {
        if (CollectionUtils.isEmpty((Collection)group.getNormalList())) {
            return;
        }
        for (OrderDetailVo detail : group.getNormalList()) {
            if (CollectionUtils.isEmpty((Collection)detail.getPromotionVos())) continue;
            for (OrderDetailPromotionVo promotionVo : detail.getPromotionVos()) {
                if (!promotionCode.equals(promotionVo.getPromotionCode())) continue;
                promotionVo.setCalSucessFlag(YesNoEnum.yesNoEnum.NO.getValue());
                StringBuilder stb = new StringBuilder("\u63d0\u793a\uff1a\u4fc3\u9500\u3010").append(group.getPromotionName()).append("\u3011\u4e0d\u5b58\u5728\u6216\u5df2\u8fc7\u671f");
                promotionVo.setCalSucessMsg(stb.toString());
            }
        }
    }

    public static boolean judegeNum(OrderGroupItemVo group, String promotionCode, PromotionEditVo promotionEditVo) {
        if (promotionEditVo.getMultipleable().equals(YesNoEnum.yesNoEnum.YES.getValue())) {
            return false;
        }
        if (CollectionUtils.isEmpty((Collection)group.getNormalList())) {
            return false;
        }
        for (OrderDetailVo detail : group.getNormalList()) {
            if (CollectionUtils.isEmpty((Collection)detail.getPromotionVos()) || detail.getPromotionVos().size() == 1) continue;
            for (OrderDetailPromotionVo promotionVo : detail.getPromotionVos()) {
                if (!promotionCode.equals(promotionVo.getPromotionCode())) continue;
                detail.setCalSucessFlag(YesNoEnum.yesNoEnum.NO.getValue());
                StringBuilder stb = new StringBuilder("\u63d0\u793a\uff1a\u4fc3\u9500\u3010").append(group.getPromotionName()).append("\u3011\u4e0d\u80fd\u53e0\u52a0");
                detail.setCalSucessMsg(stb.toString());
                return true;
            }
        }
        return false;
    }

    public static ArrayList<PromotionQueryReq> packageParam(OrderVo orderVo, String cusCode, String orgCode, Object ... objects) {
        ArrayList<PromotionQueryReq> reList = new ArrayList<PromotionQueryReq>();
        for (OrderGroupItemVo group : orderVo.getGroupItemVos()) {
            for (OrderDetailVo detail : group.getNormalList()) {
                if (CollectionUtils.isEmpty((Collection)detail.getPromotionVos())) continue;
                for (OrderDetailPromotionVo promotion : detail.getPromotionVos()) {
                    if (!promotion.getPromotionType().equals(PromotionPolicyEunm.PromotionTypeEunm.FULLREDUCTION.getCode())) continue;
                    PromotionQueryReq req = new PromotionQueryReq();
                    req.setAccountCode(cusCode);
                    req.setAccountType("customer");
                    ArrayList<String> promotionCodes = new ArrayList<String>();
                    promotionCodes.add(promotion.getPromotionCode());
                    req.setPromotionCodes(promotionCodes);
                    ArrayList<PromotionSaleProductVo> saleProductVos = new ArrayList<PromotionSaleProductVo>();
                    PromotionSaleProductVo product = new PromotionSaleProductVo();
                    product.setProductCode(detail.getProductCode());
                    product.setBuyCount(detail.getProductNum());
                    product.setBuyAmount(detail.getAmount());
                    product.setPrice(detail.getPrice());
                    saleProductVos.add(product);
                    req.setSaleProductVos(saleProductVos);
                    reList.add(req);
                }
            }
        }
        return reList;
    }
}

