/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.order.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.nebular.order.OrderFileVo;
import com.biz.crm.order.OrderFileEntity;
import com.biz.crm.order.mapper.OrderFileMapper;
import com.biz.crm.order.service.OrderFileService;
import com.biz.crm.order.utils.OrderFileUtil;
import com.biz.crm.util.CollectionUtil;
import com.biz.crm.util.CrmBeanUtil;
import com.biz.crm.util.StringUtils;
import com.biz.crm.util.ValidateUtils;
import com.google.common.collect.Lists;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@ConditionalOnMissingBean(name={"orderFileServiceExpandImpl"})
@Service(value="orderFileService")
public class OrderFileServiceImpl<M extends BaseMapper<T>, T>
extends ServiceImpl<OrderFileMapper, OrderFileEntity>
implements OrderFileService {
    @Resource
    private OrderFileMapper orderFileMapper;

    @Override
    @Transactional
    public void replace(String orderCode, List<OrderFileVo> files) {
        QueryWrapper wrapper = new QueryWrapper();
        wrapper.eq((Object)"order_code", (Object)orderCode);
        this.orderFileMapper.delete((Wrapper)wrapper);
        List<OrderFileEntity> entities = OrderFileUtil.packageEntity(orderCode, files);
        this.saveBatch(entities);
    }

    @Override
    public List<OrderFileVo> findByOrderCode(String orderCode) {
        if (StringUtils.isEmpty((String)orderCode)) {
            return Lists.newArrayList();
        }
        List entities = this.orderFileMapper.selectList((Wrapper)Wrappers.query().eq((Object)"order_code", (Object)orderCode));
        if (CollectionUtil.listEmpty((List)entities)) {
            return Lists.newArrayList();
        }
        return CrmBeanUtil.copyList((List)entities, OrderFileVo.class);
    }

    @Override
    @Transactional
    public void deleteByOrderCode(String orderCode) {
        QueryWrapper wrapper = new QueryWrapper();
        wrapper.eq((Object)"order_code", (Object)orderCode);
        this.orderFileMapper.delete((Wrapper)wrapper);
    }

    @Override
    @Transactional
    public void deleteByOrderCodes(List<String> orderCodes) {
        ValidateUtils.notEmpty(orderCodes, (String)"\u6279\u91cf\u5220\u9664\u8ba2\u5355\u6587\u4ef6\u65f6\uff0c\u8ba2\u5355\u7f16\u7801\u5217\u8868\u4e0d\u80fd\u4e3a\u7a7a", (String[])new String[0]);
        QueryWrapper wrapper = new QueryWrapper();
        wrapper.in((Object)"order_code", orderCodes);
        this.orderFileMapper.delete((Wrapper)wrapper);
    }
}

