/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.order.tools.handler;

import com.biz.crm.nebular.order.OrderDetailVo;
import com.biz.crm.nebular.order.OrderGroupItemVo;
import com.biz.crm.nebular.order.OrderVo;
import java.util.ArrayList;
import java.util.Collection;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@ConditionalOnMissingBean(name={"orderCalPriceHandlerExpand"})
@Component(value="orderCalPriceHandler")
public class OrderCalPriceHandler {
    public OrderVo cal(OrderVo orderVo) {
        for (OrderGroupItemVo groupItemVo : orderVo.getGroupItemVos()) {
            this.calItemPrice(orderVo, groupItemVo);
        }
        return orderVo;
    }

    public void calItemPrice(OrderVo orderVo, OrderGroupItemVo groupItemVo) {
        if (!CollectionUtils.isEmpty((Collection)groupItemVo.getBackList())) {
            for (OrderDetailVo item : groupItemVo.getBackList()) {
                item.setAmount(item.getPrice().multiply(item.getProductNum()).setScale(6, 4));
            }
        }
        if (!CollectionUtils.isEmpty((Collection)groupItemVo.getGiftList())) {
            ArrayList giftList = new ArrayList();
            for (OrderDetailVo item : groupItemVo.getGiftList()) {
                if (item.getProductNum() == null) continue;
                item.setAmount(item.getPrice().multiply(item.getProductNum()).setScale(6, 4));
            }
        }
        if (!CollectionUtils.isEmpty((Collection)groupItemVo.getNormalList())) {
            ArrayList normalList = new ArrayList();
            for (OrderDetailVo item : groupItemVo.getNormalList()) {
                item.setAmount(item.getPrice().multiply(item.getProductNum()).setScale(6, 4));
            }
        }
    }
}

