/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.order.tools.strategy.ordervalidateparam.impl;

import com.biz.crm.base.BusinessException;
import com.biz.crm.eunm.YesNoEnum;
import com.biz.crm.eunm.dms.OrderEunm;
import com.biz.crm.nebular.order.OrderDetailPromotionVo;
import com.biz.crm.nebular.order.OrderDetailVo;
import com.biz.crm.nebular.order.OrderGroupItemVo;
import com.biz.crm.nebular.order.OrderVo;
import com.biz.crm.order.tools.strategy.ordervalidateparam.OrderValidateParamStrategy;
import com.biz.crm.util.StringUtils;
import com.biz.crm.util.ValidateUtils;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@ConditionalOnMissingBean(name={"standerdOrderValidateParamStrategyExpand"})
@Component(value="standerdOrderValidateParamStrategy")
public class StanderdOrderValidateParamStrategy
implements OrderValidateParamStrategy {
    @Override
    public void validate(OrderVo orderVo, Object ... objects) {
        ValidateUtils.validate((Object)orderVo.getCusCode(), (String)"\u8bf7\u5148\u9009\u62e9\u7ecf\u9500\u5546!");
        if (CollectionUtils.isEmpty((Collection)orderVo.getGroupItemVos())) {
            throw new BusinessException("\u5546\u54c1\u4fe1\u606f\u4e3a\u7a7a!");
        }
        for (OrderGroupItemVo groupItemVo : orderVo.getGroupItemVos()) {
            groupItemVo.setCalSucessFlag(YesNoEnum.yesNoEnum.YES.getValue());
            groupItemVo.setPromotionAmount(BigDecimal.ZERO);
            if (StringUtils.isEmpty((String)groupItemVo.getBuyAndGiveFlag())) {
                throw new BusinessException("\u9519\u8bef\u8ba2\u5355\uff0c\u8bf7\u68c0\u67e5!");
            }
            if (CollectionUtils.isEmpty((Collection)groupItemVo.getBackList()) && CollectionUtils.isEmpty((Collection)groupItemVo.getNormalList())) {
                throw new BusinessException("\u9519\u8bef\u8ba2\u5355\uff0c\u8bf7\u68c0\u67e5!");
            }
            StanderdOrderValidateParamStrategy.validateForDetail(groupItemVo.getBackList(), objects);
            groupItemVo.getGiftList().forEach(item -> item.setLineType(OrderEunm.LineTypeEnum.GIFT_PRODUCT.getCode()));
            StanderdOrderValidateParamStrategy.validateForDetail(groupItemVo.getGiftList(), objects);
            StanderdOrderValidateParamStrategy.validateForDetail(groupItemVo.getNormalList(), objects);
            StanderdOrderValidateParamStrategy.validatePromotionBlock(groupItemVo);
        }
    }

    public static void validateForDetail(List<OrderDetailVo> list, Object ... objects) {
        if (CollectionUtils.isEmpty(list)) {
            return;
        }
        for (OrderDetailVo item : list) {
            item.setCalSucessFlag(YesNoEnum.yesNoEnum.YES.getValue());
            ValidateUtils.validate((Object)item.getProductCode(), (String)"\u5546\u54c1\u7f16\u7801\u4e3a\u7a7a!");
            if (!Objects.equals(OrderEunm.LineTypeEnum.GIFT_PRODUCT.getCode(), item.getLineType())) {
                ValidateUtils.validate((Object)item.getProductNum(), (String)"\u5546\u54c1\u6570\u91cf\u4e3a\u7a7a!");
            }
            StanderdOrderValidateParamStrategy.validatePromotion(item.getPromotionVos());
        }
    }

    public static void validatePromotion(ArrayList<OrderDetailPromotionVo> promotionVos) {
        if (CollectionUtils.isEmpty(promotionVos)) {
            return;
        }
        for (OrderDetailPromotionVo promotion : promotionVos) {
            promotion.setCalSucessFlag(YesNoEnum.yesNoEnum.YES.getValue());
            ValidateUtils.validate((Object)promotion.getPromotionCode(), (String)"\u4fc3\u9500\u7f16\u7801\u4e3a\u7a7a!");
            ValidateUtils.validate((Object)promotion.getPromotionName(), (String)"\u4fc3\u9500\u540d\u79f0\u4e3a\u7a7a!");
            ValidateUtils.validate((Object)promotion.getPromotionType(), (String)"\u4fc3\u9500\u7c7b\u578b\u4e3a\u7a7a!");
        }
    }

    public static void validatePromotionBlock(OrderGroupItemVo groupItemVo) {
        if (groupItemVo.getBuyAndGiveFlag().equals(YesNoEnum.yesNoEnum.NO.getValue())) {
            return;
        }
        ValidateUtils.validate((Object)groupItemVo.getPromotionCode(), (String)"\u5757\u4fc3\u9500\u7c7b\u578b\u4e3a\u7a7a!");
        for (OrderDetailVo item : groupItemVo.getNormalList()) {
            if (CollectionUtils.isEmpty((Collection)item.getPromotionVos())) continue;
            for (OrderDetailPromotionVo promotionVo : item.getPromotionVos()) {
                if (!promotionVo.getPromotionCode().equals(groupItemVo.getPromotionCode())) continue;
                return;
            }
        }
        throw new BusinessException("\u9519\u8bef\u8ba2\u5355\uff0c\u8bf7\u68c0\u67e5!");
    }
}

