/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.order.tools.handler;

import com.biz.crm.base.BusinessException;
import com.biz.crm.eunm.YesNoEnum;
import com.biz.crm.eunm.dms.OrderEunm;
import com.biz.crm.eunm.dms.PromotionPolicyEunm;
import com.biz.crm.nebular.mdm.dict.resp.DictDataVo;
import com.biz.crm.nebular.order.OrderDetailPromotionVo;
import com.biz.crm.nebular.order.OrderDetailVo;
import com.biz.crm.nebular.order.OrderGroupItemVo;
import com.biz.crm.nebular.order.OrderVo;
import com.biz.crm.order.tools.excutor.CalPromotionExcutor;
import com.biz.crm.order.tools.strategy.calpromotion.impl.BuyAndGiftCalPromotionStrategy;
import com.biz.crm.order.tools.strategy.calpromotion.impl.DiscountCalPromotionStrategy;
import com.biz.crm.order.tools.strategy.calpromotion.impl.FullReductionCalPromotionStrategy;
import com.biz.crm.order.tools.strategy.calpromotion.impl.SpecialOfferCalPromotionStrategy;
import com.biz.crm.order.utils.OrderUtil;
import com.biz.crm.util.DictUtil;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@ConditionalOnMissingBean(name={"orderPromotionHandlerExpand"})
@Component(value="orderPromotionHandler")
public class OrderPromotionHandler {
    @Resource
    private BuyAndGiftCalPromotionStrategy buyAndGiftCalPromotionStrategy;
    @Resource
    private DiscountCalPromotionStrategy discountCalPromotionStrategy;
    @Resource
    private FullReductionCalPromotionStrategy fullReductionCalPromotionStrategy;
    @Resource
    private SpecialOfferCalPromotionStrategy specialOfferCalPromotionStrategy;

    public OrderVo handle(OrderVo orderVo, String cusCode, String orgCode, Object ... objects) {
        if (!OrderUtil.judegeOrder(orderVo = OrderPromotionHandler.validateParam(orderVo))) {
            return orderVo;
        }
        List list = DictUtil.list((String)"cal_promotion_sort");
        if (CollectionUtils.isEmpty((Collection)list)) {
            throw new BusinessException("\u4fc3\u9500\u914d\u7f6e\u7f3a\u5931\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458");
        }
        List newList = list.stream().sorted(Comparator.comparing(DictDataVo::getDictSort)).collect(Collectors.toList());
        int calNum = 1;
        for (DictDataVo dictDataVo : newList) {
            if (dictDataVo.getDictCode().equals(PromotionPolicyEunm.PromotionTypeEunm.BUYGIFT.getCode())) {
                if (OrderUtil.judegeOrder(orderVo = CalPromotionExcutor.cal(this.buyAndGiftCalPromotionStrategy, orderVo, cusCode, orgCode, calNum, objects))) continue;
                return orderVo;
            }
            if (dictDataVo.getDictCode().equals(PromotionPolicyEunm.PromotionTypeEunm.FULLREDUCTION.getCode())) {
                if (OrderUtil.judegeOrder(orderVo = CalPromotionExcutor.cal(this.fullReductionCalPromotionStrategy, orderVo, cusCode, orgCode, calNum, objects))) continue;
                return orderVo;
            }
            if (dictDataVo.getDictCode().equals(PromotionPolicyEunm.PromotionTypeEunm.DISCOUNT.getCode())) {
                if (OrderUtil.judegeOrder(orderVo = CalPromotionExcutor.cal(this.discountCalPromotionStrategy, orderVo, cusCode, orgCode, calNum, objects))) continue;
                return orderVo;
            }
            if (dictDataVo.getDictCode().equals(PromotionPolicyEunm.PromotionTypeEunm.SPECIALPRICE.getCode())) {
                if (OrderUtil.judegeOrder(orderVo = CalPromotionExcutor.cal(this.specialOfferCalPromotionStrategy, orderVo, cusCode, orgCode, calNum, objects))) continue;
                return orderVo;
            }
            ++calNum;
        }
        return orderVo;
    }

    public static OrderVo validateParam(OrderVo orderVo) {
        HashMap promotionMap = new HashMap();
        for (OrderGroupItemVo group : orderVo.getGroupItemVos()) {
            if (CollectionUtils.isEmpty((Collection)group.getNormalList())) continue;
            if (group.getBuyAndGiveFlag().equals(YesNoEnum.yesNoEnum.YES) && promotionMap.get(group.getPromotionCode()) != null) {
                orderVo.setCalSucessFlag(YesNoEnum.yesNoEnum.NO.getValue());
                orderVo.setCalSucessMsgType(OrderEunm.calSucessMsgTypeEnum.GROUP.getCode());
                group.setCalSucessFlag(YesNoEnum.yesNoEnum.NO.getValue());
                StringBuilder stb = new StringBuilder("\u63d0\u793a\uff1a\u9519\u8bef\u8ba2\u5355\uff0c\u4e70\u8d60\u4fc3\u9500\u91cd\u590d");
                group.setCalSucessMsg(stb.toString());
                return orderVo;
            }
            for (OrderDetailVo detail : group.getNormalList()) {
                if (CollectionUtils.isEmpty((Collection)detail.getPromotionVos())) continue;
                HashMap map = new HashMap();
                for (OrderDetailPromotionVo promotionVo : detail.getPromotionVos()) {
                    if (map.get(promotionVo.getPromotionCode()) == null) continue;
                    orderVo.setCalSucessFlag(YesNoEnum.yesNoEnum.NO.getValue());
                    orderVo.setCalSucessMsgType(OrderEunm.calSucessMsgTypeEnum.LINE.getCode());
                    detail.setCalSucessFlag(YesNoEnum.yesNoEnum.NO.getValue());
                    StringBuilder stb = new StringBuilder("\u63d0\u793a\uff1a\u884c\u4e0a\u4fc3\u9500\u7c7b\u578b\u91cd\u590d");
                    detail.setCalSucessMsg(stb.toString());
                    return orderVo;
                }
            }
        }
        return orderVo;
    }
}

