/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.order.utils;

import com.biz.crm.eunm.YesNoEnum;
import com.biz.crm.eunm.dms.PromotionPolicyEunm;
import com.biz.crm.nebular.order.OrderDetailCollectVo;
import com.biz.crm.nebular.order.OrderDetailPromotionVo;
import com.biz.crm.nebular.order.OrderDetailVo;
import com.biz.crm.nebular.order.OrderGroupItemVo;
import com.biz.crm.nebular.order.OrderVo;
import com.biz.crm.order.OrderEntity;
import com.biz.crm.order.utils.OrderCodeUtil;
import com.biz.crm.service.RedisService;
import com.biz.crm.util.CodeUtil;
import com.biz.crm.util.CollectionUtil;
import com.biz.crm.util.StringUtils;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.springframework.beans.BeanUtils;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@ConditionalOnMissingBean(name={"orderUtilExpand"})
@Component(value="orderUtil")
public class OrderUtil {
    public static final String CAL_PROMOTION_SORT_CODE = "cal_promotion_sort";

    public static void collect(OrderVo orderVo) {
        HashMap<String, OrderDetailCollectVo> totalMap = new HashMap<String, OrderDetailCollectVo>();
        for (OrderGroupItemVo group : orderVo.getGroupItemVos()) {
            if (!CollectionUtils.isEmpty((Collection)group.getNormalList())) {
                for (OrderDetailVo detail : group.getNormalList()) {
                    OrderUtil.collectProduct(detail, totalMap);
                }
            }
            if (!CollectionUtils.isEmpty((Collection)group.getGiftList())) {
                for (OrderDetailVo detail : group.getGiftList()) {
                    OrderUtil.collectProduct(detail, totalMap);
                }
            }
            if (CollectionUtils.isEmpty((Collection)group.getBackList())) continue;
            for (OrderDetailVo detail : group.getBackList()) {
                OrderUtil.collectProduct(detail, totalMap);
            }
        }
        orderVo.setOrderDetailCollectVos(CollectionUtils.isEmpty(totalMap) ? new ArrayList() : new ArrayList(totalMap.values()));
        orderVo.setGroupItemVos(new ArrayList());
    }

    public static void collectProduct(OrderDetailVo detail, Map<String, OrderDetailCollectVo> totalMap) {
        OrderDetailCollectVo vo = totalMap.get(detail.getProductCode());
        if (null == vo) {
            vo = new OrderDetailCollectVo();
            BeanUtils.copyProperties((Object)detail, (Object)vo);
            totalMap.put(detail.getProductCode(), vo);
            return;
        }
        vo.setAmount(vo.getAmount().add(detail.getAmount()));
        vo.setProductNum(vo.getProductNum().add(detail.getProductNum()));
    }

    public static OrderVo packagePromotionToVo(OrderVo orderVo, List<OrderDetailPromotionVo> promotionVos) {
        for (OrderGroupItemVo group : orderVo.getGroupItemVos()) {
            if (CollectionUtils.isEmpty((Collection)group.getNormalList())) {
                group.setBuyAndGiveFlag(YesNoEnum.yesNoEnum.NO.getValue());
                continue;
            }
            ArrayList<OrderDetailPromotionVo> allPromotion = new ArrayList<OrderDetailPromotionVo>();
            for (OrderDetailVo detail : group.getNormalList()) {
                ArrayList<OrderDetailPromotionVo> linePromotions = OrderUtil.findPromotionByLineNo(detail.getLineNo(), promotionVos);
                detail.setPromotionVos(linePromotions);
                allPromotion.addAll(linePromotions);
            }
            OrderDetailPromotionVo buyGiftPromotion = OrderUtil.findBuyGiftPromotion(allPromotion);
            if (null == buyGiftPromotion) {
                group.setBuyAndGiveFlag(YesNoEnum.yesNoEnum.NO.getValue());
                continue;
            }
            group.setBuyAndGiveFlag(YesNoEnum.yesNoEnum.YES.getValue());
            group.setPromotionCode(buyGiftPromotion.getPromotionCode());
            group.setPromotionName(buyGiftPromotion.getPromotionName());
        }
        return orderVo;
    }

    public static OrderDetailPromotionVo findBuyGiftPromotion(ArrayList<OrderDetailPromotionVo> allPromotion) {
        if (CollectionUtils.isEmpty(allPromotion)) {
            return null;
        }
        for (OrderDetailPromotionVo promotion : allPromotion) {
            if (!promotion.getPromotionType().equals(PromotionPolicyEunm.PromotionTypeEunm.BUYGIFT.getCode())) continue;
            return promotion;
        }
        return null;
    }

    public static ArrayList<OrderDetailPromotionVo> findPromotionByLineNo(String lineNo, List<OrderDetailPromotionVo> promotionVos) {
        ArrayList<OrderDetailPromotionVo> reList = new ArrayList<OrderDetailPromotionVo>();
        for (OrderDetailPromotionVo promotion : promotionVos) {
            if (!promotion.getOrderDetailLineNo().equals(lineNo)) continue;
            reList.add(promotion);
        }
        return reList;
    }

    public static List<OrderDetailPromotionVo> extractPromotion(OrderVo orderVo) {
        ArrayList<OrderDetailPromotionVo> list = new ArrayList<OrderDetailPromotionVo>();
        for (OrderGroupItemVo group : orderVo.getGroupItemVos()) {
            if (CollectionUtils.isEmpty((Collection)group.getNormalList())) continue;
            for (OrderDetailVo detail : group.getNormalList()) {
                if (CollectionUtils.isEmpty((Collection)detail.getPromotionVos())) continue;
                list.addAll(detail.getPromotionVos());
            }
        }
        return list;
    }

    public static boolean judegeOrder(OrderVo orderVo) {
        return !orderVo.getCalSucessFlag().equals(YesNoEnum.yesNoEnum.NO.getValue());
    }

    public static boolean judegeOrderGroup(OrderGroupItemVo group) {
        return !group.getCalSucessFlag().equals(YesNoEnum.yesNoEnum.NO.getValue());
    }

    public OrderEntity packageOrderHead(OrderVo orderVo) {
        OrderEntity orderEntity = new OrderEntity();
        BeanUtils.copyProperties((Object)orderVo, (Object)orderEntity);
        orderEntity.setOrderCode(CodeUtil.getCodeDefault());
        return orderEntity;
    }

    public OrderEntity packageOrderHeadForEndit(OrderVo orderVo, OrderEntity orderEntity) {
        String id = orderEntity.getId();
        String orderCode = orderEntity.getOrderCode();
        BeanUtils.copyProperties((Object)orderVo, (Object)orderEntity);
        orderEntity.setId(id);
        orderEntity.setOrderCode(orderCode);
        return orderEntity;
    }

    public OrderVo createLineAndSort(OrderVo orderVo) {
        int groupNum = 1;
        int lineNum = 1;
        for (OrderGroupItemVo orderGroupItemVo : orderVo.getGroupItemVos()) {
            String groupCode = OrderCodeUtil.fullFour(groupNum);
            orderGroupItemVo.setGroupCode(groupCode);
            if (!CollectionUtils.isEmpty((Collection)orderGroupItemVo.getBackList())) {
                for (OrderDetailVo item : orderGroupItemVo.getBackList()) {
                    item.setGroupCode(groupCode);
                    item.setLineNo(OrderCodeUtil.fullFour(lineNum));
                    OrderUtil.zPromotionLineNum(OrderCodeUtil.fullFour(lineNum), item);
                    item.setOnlykey(item.getLineNo() + "," + item.getProductCode());
                    ++lineNum;
                }
            }
            if (!CollectionUtils.isEmpty((Collection)orderGroupItemVo.getNormalList())) {
                for (OrderDetailVo item : orderGroupItemVo.getNormalList()) {
                    item.setGroupCode(groupCode);
                    item.setLineNo(OrderCodeUtil.fullFour(lineNum));
                    OrderUtil.zPromotionLineNum(OrderCodeUtil.fullFour(lineNum), item);
                    item.setOnlykey(item.getLineNo() + "," + item.getProductCode());
                    ++lineNum;
                }
            }
            if (!CollectionUtils.isEmpty((Collection)orderGroupItemVo.getGiftList())) {
                for (OrderDetailVo item : orderGroupItemVo.getGiftList()) {
                    item.setGroupCode(groupCode);
                    item.setLineNo(OrderCodeUtil.fullFour(lineNum));
                    OrderUtil.zPromotionLineNum(OrderCodeUtil.fullFour(lineNum), item);
                    item.setOnlykey(item.getLineNo() + "," + item.getProductCode());
                    ++lineNum;
                }
            }
            ++groupNum;
        }
        return OrderUtil.sort(orderVo);
    }

    public static void zPromotionLineNum(String lineNum, OrderDetailVo item) {
        if (CollectionUtils.isEmpty((Collection)item.getPromotionVos())) {
            return;
        }
        for (OrderDetailPromotionVo promotionVo : item.getPromotionVos()) {
            promotionVo.setOrderDetailLineNo(lineNum);
        }
    }

    public static OrderVo sort(OrderVo orderVo) {
        List groupItemVos = orderVo.getGroupItemVos();
        groupItemVos = groupItemVos.stream().sorted(Comparator.comparing(OrderGroupItemVo::getGroupCode)).collect(Collectors.toList());
        for (OrderGroupItemVo orderGroupItemVo : groupItemVos) {
            List list;
            if (!CollectionUtils.isEmpty((Collection)orderGroupItemVo.getBackList())) {
                list = orderGroupItemVo.getBackList().stream().sorted(Comparator.comparing(OrderDetailVo::getLineNo)).collect(Collectors.toList());
                orderGroupItemVo.setBackList(list);
            }
            if (!CollectionUtils.isEmpty((Collection)orderGroupItemVo.getNormalList())) {
                list = orderGroupItemVo.getNormalList().stream().sorted(Comparator.comparing(OrderDetailVo::getLineNo)).collect(Collectors.toList());
                orderGroupItemVo.setNormalList(list);
            }
            if (CollectionUtils.isEmpty((Collection)orderGroupItemVo.getGiftList())) continue;
            list = orderGroupItemVo.getGiftList().stream().sorted(Comparator.comparing(OrderDetailVo::getLineNo)).collect(Collectors.toList());
            orderGroupItemVo.setGiftList(list);
        }
        orderVo.setGroupItemVos(groupItemVos);
        return orderVo;
    }

    public static void reduceGiftCount(OrderVo orderVo, RedisService redisService) {
        if (orderVo == null || CollectionUtil.listEmpty((List)orderVo.getGroupItemVos())) {
            return;
        }
        orderVo.getGroupItemVos().forEach(group -> {
            List normalList = group.getNormalList();
            String promotionCode = null;
            if (CollectionUtil.listNotEmpty((List)normalList)) {
                Object n;
                Iterator iterator = normalList.iterator();
                while (iterator.hasNext() && !StringUtils.isNotEmpty((String)(promotionCode = OrderUtil.getGiftPromotion((OrderDetailVo)(n = (OrderDetailVo)iterator.next()))))) {
                }
            }
            if (StringUtils.isNotEmpty(promotionCode) && CollectionUtil.listNotEmpty((List)group.getGiftList())) {
                BigDecimal giftCount = BigDecimal.ZERO;
                for (OrderDetailVo detailVo : group.getGiftList()) {
                    giftCount = giftCount.add(detailVo.getProductNum() == null ? BigDecimal.ZERO : detailVo.getProductNum());
                }
                BigDecimal totalCount = (BigDecimal)redisService.get("crm:dms:promotion:gift:".concat(orderVo.getCusCode().concat("-").concat(promotionCode)));
                totalCount = totalCount == null ? BigDecimal.ZERO : totalCount;
                totalCount = totalCount.subtract(giftCount);
                totalCount = totalCount.compareTo(BigDecimal.ZERO) < 0 ? BigDecimal.ZERO : totalCount;
                redisService.set(promotionCode, (Object)totalCount);
            }
        });
    }

    public static void saveGiftCount(OrderVo orderVo, RedisService redisService) {
        if (orderVo == null || CollectionUtil.listEmpty((List)orderVo.getGroupItemVos())) {
            return;
        }
        orderVo.getGroupItemVos().forEach(group -> {
            List normalList = group.getNormalList();
            String promotionCode = null;
            if (CollectionUtil.listNotEmpty((List)normalList)) {
                Object n;
                Iterator iterator = normalList.iterator();
                while (iterator.hasNext() && !StringUtils.isNotEmpty((String)(promotionCode = OrderUtil.getGiftPromotion((OrderDetailVo)(n = (OrderDetailVo)iterator.next()))))) {
                }
            }
            if (StringUtils.isNotEmpty(promotionCode) && CollectionUtil.listNotEmpty((List)group.getGiftList())) {
                BigDecimal giftCount = BigDecimal.ZERO;
                for (OrderDetailVo detailVo : group.getGiftList()) {
                    giftCount = giftCount.add(detailVo.getProductNum() == null ? BigDecimal.ZERO : detailVo.getProductNum());
                }
                BigDecimal totalCount = (BigDecimal)redisService.get("crm:dms:promotion:gift:".concat(orderVo.getCusCode().concat("-").concat(promotionCode)));
                totalCount = totalCount == null ? BigDecimal.ZERO : totalCount;
                redisService.set("crm:dms:promotion:gift:".concat(orderVo.getCusCode().concat("-").concat(promotionCode)), (Object)totalCount.add(giftCount));
            }
        });
    }

    private static String getGiftPromotion(OrderDetailVo detailVo) {
        if (detailVo == null || CollectionUtil.listEmpty((List)detailVo.getPromotionVos())) {
            return null;
        }
        for (OrderDetailPromotionVo promotionVo : detailVo.getPromotionVos()) {
            if (!Objects.equals(promotionVo.getPromotionType(), PromotionPolicyEunm.PromotionTypeEunm.BUYGIFT.getCode())) continue;
            return promotionVo.getPromotionCode();
        }
        return null;
    }
}

