/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.order.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.nebular.order.OrderDetailPromotionVo;
import com.biz.crm.order.OrderDetailPromotionEntity;
import com.biz.crm.order.OrderEntity;
import com.biz.crm.order.mapper.OrderDetailPromotionMapper;
import com.biz.crm.order.service.OrderDetailPromotionService;
import com.biz.crm.order.utils.OrderDetailPromotionUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@ConditionalOnMissingBean(name={"orderDetailPromotionServiceExpandImpl"})
@Service(value="orderDetailPromotionService")
public class OrderDetailPromotionServiceImpl<M extends BaseMapper<T>, T>
extends ServiceImpl<OrderDetailPromotionMapper, OrderDetailPromotionEntity>
implements OrderDetailPromotionService {
    @Autowired
    private OrderDetailPromotionMapper orderDetailPromotionMapper;

    @Override
    public void rePlace(OrderEntity orderEntity, List<OrderDetailPromotionVo> promotionVos) {
        QueryWrapper wrapper = new QueryWrapper();
        wrapper.eq((Object)"order_code", (Object)orderEntity.getOrderCode());
        this.orderDetailPromotionMapper.delete((Wrapper)wrapper);
        List<OrderDetailPromotionEntity> entities = OrderDetailPromotionUtil.packageEntity(orderEntity, promotionVos);
        if (CollectionUtils.isEmpty(entities)) {
            return;
        }
        this.saveBatch(entities);
    }

    @Override
    public List<OrderDetailPromotionVo> findPromotionByOrderCode(String orderCode) {
        QueryWrapper wrapper = new QueryWrapper();
        wrapper.eq((Object)"order_code", (Object)orderCode);
        List entities = this.orderDetailPromotionMapper.selectList((Wrapper)wrapper);
        if (CollectionUtils.isEmpty((Collection)entities)) {
            return new ArrayList<OrderDetailPromotionVo>();
        }
        return OrderDetailPromotionUtil.packageVo(entities);
    }

    @Override
    public void delByOrderCode(String orderCode) {
        QueryWrapper wrapper = new QueryWrapper();
        wrapper.eq((Object)"order_code", (Object)orderCode);
        this.orderDetailPromotionMapper.delete((Wrapper)wrapper);
    }
}

