/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.order.tools.strategy.validaterebate.impl;

import com.biz.crm.base.BusinessException;
import com.biz.crm.eunm.YesNoEnum;
import com.biz.crm.eunm.dms.OrderEunm;
import com.biz.crm.fee.pool.FeePoolFeign;
import com.biz.crm.nebular.fee.pool.req.FeePoolAmountQueryReqVo;
import com.biz.crm.nebular.fee.pool.resp.FeePoolAmountQueryRespVo;
import com.biz.crm.nebular.order.OrderDetailVo;
import com.biz.crm.nebular.order.OrderGroupItemVo;
import com.biz.crm.nebular.order.OrderVo;
import com.biz.crm.order.tools.strategy.validaterebate.ValidateRebateFeeStrategy;
import com.biz.crm.util.Result;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@ConditionalOnMissingBean(name={"rebateOrderValidateFeeStategyExpand"})
@Component(value="rebateOrderValidateFeeStategy")
public class RebateOrderValidateFeeStategy
implements ValidateRebateFeeStrategy {
    @Autowired
    private FeePoolFeign feePoolFeign;

    @Override
    public OrderVo validate(OrderVo orderVo, String cusCode, String orgCode, Object ... objects) {
        FeePoolAmountQueryReqVo feePoolAmountQueryReqVo = this.packageFeeParam(orderVo, cusCode);
        Result result = this.feePoolFeign.queryPoolAmount(feePoolAmountQueryReqVo);
        if (!result.isSuccess()) {
            throw new BusinessException("\u8d39\u7528\u670d\u52a1\u6b63\u5728\u91cd\u542f\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458");
        }
        FeePoolAmountQueryRespVo feePoolAmountQueryRespVo = (FeePoolAmountQueryRespVo)result.getResult();
        orderVo = this.calRapFromFee(orderVo, feePoolAmountQueryRespVo.getPoolUsableAmountMap());
        return orderVo;
    }

    public OrderVo calRapFromFee(OrderVo orderVo, Map<String, BigDecimal> poolMap) {
        for (OrderGroupItemVo groupItemVo : orderVo.getGroupItemVos()) {
            if (CollectionUtils.isEmpty((Collection)groupItemVo.getBackList())) continue;
            for (OrderDetailVo itemVo : groupItemVo.getBackList()) {
                StringBuilder stb;
                BigDecimal ableFee = poolMap.get(itemVo.getFeeCode());
                if (null == ableFee) {
                    orderVo.setCalSucessFlag(YesNoEnum.yesNoEnum.NO.getValue());
                    orderVo.setCalSucessMsgType(OrderEunm.calSucessMsgTypeEnum.LINE.getCode());
                    itemVo.setCalSucessFlag(YesNoEnum.yesNoEnum.NO.getValue());
                    stb = new StringBuilder("\u63d0\u793a\uff1a\u8d27\u8865\u5546\u54c1\u3010").append(itemVo.getProductName()).append("\u3011\u5bf9\u5e94\u7684\u8d39\u7528\u3010").append(itemVo.getFeeName()).append("\u3011\u5269\u4f59\u4e3a0,\u8bf7\u91cd\u65b0\u9009\u62e9");
                    itemVo.setCalSucessMsg(stb.toString());
                    continue;
                }
                if (itemVo.getAmount().compareTo(ableFee) <= 0) continue;
                orderVo.setCalSucessFlag(YesNoEnum.yesNoEnum.NO.getValue());
                orderVo.setCalSucessMsgType(OrderEunm.calSucessMsgTypeEnum.LINE.getCode());
                itemVo.setCalSucessFlag(YesNoEnum.yesNoEnum.NO.getValue());
                stb = new StringBuilder("\u63d0\u793a\uff1a\u8d27\u8865\u5546\u54c1\u3010").append(itemVo.getProductName()).append("\u3011\u5df2\u8d85\u8fc7\u8d39\u7528\u3010").append(itemVo.getFeeName()).append("\u3011\u7684\u6700\u5927\u9650\u989d").append(ableFee).append("\u5143\u3011,\u8bf7\u8c03\u6574\u6570\u91cf\u6216\u8005\u52a0\u5927\u5546\u54c1\u8d2d\u4e70\u91cf\uff01");
                itemVo.setCalSucessMsg(stb.toString());
            }
        }
        return orderVo;
    }

    public FeePoolAmountQueryReqVo packageFeeParam(OrderVo orderVo, String cusCode) {
        FeePoolAmountQueryReqVo vo = new FeePoolAmountQueryReqVo();
        vo.setCustomerCode(cusCode);
        ArrayList<String> poolCodeList = new ArrayList<String>();
        for (OrderGroupItemVo groupItemVo : orderVo.getGroupItemVos()) {
            if (CollectionUtils.isEmpty((Collection)groupItemVo.getBackList())) continue;
            for (OrderDetailVo itemVo : groupItemVo.getBackList()) {
                poolCodeList.add(itemVo.getFeeCode());
            }
        }
        vo.setPoolCodeList(poolCodeList);
        return vo;
    }
}

