package com.biz.crm.order.service.impl;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.base.ApiResultUtil;
import com.biz.crm.base.BusinessException;
import com.biz.crm.base.config.ThreadLocalUtil;
import com.biz.crm.common.GlobalParam;
import com.biz.crm.common.PageResult;
import com.biz.crm.crmlog.handle.util.CrmLogSendUtil;
import com.biz.crm.eunm.YesNoEnum;
import com.biz.crm.eunm.dms.FromTypeEunm;
import com.biz.crm.eunm.dms.OrderEunm;
import com.biz.crm.mdm.customer.MdmCustomerMsgFeign;
import com.biz.crm.mq.RocketMQConstant;
import com.biz.crm.mq.RocketMQMessageBody;
import com.biz.crm.mq.RocketMQProducer;
import com.biz.crm.nebular.dms.promotion.policy.req.DmsPromotionPolicyOrderDetailReqVo;
import com.biz.crm.nebular.mdm.customer.MdmCustomerMsgRespVo;
import com.biz.crm.nebular.order.OrderDetailPromotionVo;
import com.biz.crm.nebular.order.OrderFileVo;
import com.biz.crm.nebular.order.OrderGroupItemVo;
import com.biz.crm.nebular.order.OrderVo;
import com.biz.crm.order.OrderDetailEntity;
import com.biz.crm.order.OrderEntity;
import com.biz.crm.order.mapper.OrderMapper;
import com.biz.crm.order.service.OrderDetailPromotionService;
import com.biz.crm.order.service.OrderDetailService;
import com.biz.crm.order.service.OrderFileService;
import com.biz.crm.order.service.OrderService;
import com.biz.crm.order.tools.excutor.CalOrderExcutor;
import com.biz.crm.order.tools.excutor.CompletionProductMsgExcutor;
import com.biz.crm.order.tools.excutor.OrderValidateParamExcutor;
import com.biz.crm.order.tools.excutor.ValidateRebateFeeExcutor;
import com.biz.crm.order.tools.handler.OrderBackFeeHandler;
import com.biz.crm.order.tools.handler.OrderCalPriceHandler;
import com.biz.crm.order.tools.handler.OrderMinBuyNumHandler;
import com.biz.crm.order.tools.handler.OrderPromotionHandler;
import com.biz.crm.order.tools.handler.OrderUseFeeHandler;
import com.biz.crm.order.tools.strategy.calorder.impl.FreeCalOrderStrategy;
import com.biz.crm.order.tools.strategy.calorder.impl.RebateCalOrderStrategy;
import com.biz.crm.order.tools.strategy.calorder.impl.StanderdCalOrderStrategy;
import com.biz.crm.order.tools.strategy.completionproductmsg.impl.FreeCompletionProductMsgStrategy;
import com.biz.crm.order.tools.strategy.completionproductmsg.impl.RebateCompletionProductMsgStrategy;
import com.biz.crm.order.tools.strategy.completionproductmsg.impl.StanderdCompletionProductMsgStrategy;
import com.biz.crm.order.tools.strategy.ordervalidateparam.impl.FreeOrderValidateParamStrategy;
import com.biz.crm.order.tools.strategy.ordervalidateparam.impl.RebateOrderValidateParamStrategy;
import com.biz.crm.order.tools.strategy.ordervalidateparam.impl.StanderdOrderValidateParamStrategy;
import com.biz.crm.order.tools.strategy.validaterebate.impl.RebateOrderValidateFeeStategy;
import com.biz.crm.order.tools.strategy.validaterebate.impl.StanderdOrderValidateFeeStategy;
import com.biz.crm.order.utils.OrderUtil;
import com.biz.crm.service.RedisService;
import com.biz.crm.util.CrmBeanUtil;
import com.biz.crm.util.StringUtils;
import com.biz.crm.util.UserRedis;
import com.biz.crm.util.UserUtils;
import com.biz.crm.util.ValidateUtils;
import com.google.common.collect.Lists;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

import javax.annotation.Resource;
import java.util.List;
import java.util.Objects;

/**
 * @Description:
 * @Author: zhangyuzhu
 * @Date: 2021/1/28 16:49
 **/
@ConditionalOnMissingBean(name = "orderServiceExpandImpl")
@Service(value = "orderService")
public class OrderServiceImpl<M extends BaseMapper<T>, T>
        extends ServiceImpl<OrderMapper, OrderEntity>
        implements OrderService {

    @Resource
    private OrderMapper orderMapper;

    @Resource
    private OrderDetailService orderDetailService;

    @Resource
    private OrderFileService orderFileService;

    @Resource
    private OrderUtil orderUtil;

    @Resource
    private MdmCustomerMsgFeign mdmCustomerMsgFeign;

    @Resource
    private FreeOrderValidateParamStrategy freeOrderValidateParamStrategy;

    @Resource
    private RebateOrderValidateParamStrategy rebateOrderValidateParamStrategy;

    @Resource
    private StanderdOrderValidateParamStrategy standerdOrderValidateParamStrategy;

    @Resource
    private StanderdCompletionProductMsgStrategy standerdCompletionProductMsgStrategy;

    @Resource
    private RebateCompletionProductMsgStrategy rebateCompletionProductMsgStrategy;

    @Resource
    private FreeCompletionProductMsgStrategy freeCompletionProductMsgStrategy;

    @Resource
    private StanderdOrderValidateFeeStategy standerdOrderValidateFeeStategy;

    @Resource
    private RebateOrderValidateFeeStategy rebateOrderValidateFeeStategy;

    @Resource
    private StanderdCalOrderStrategy standerdCalOrderStrategy;

    @Resource
    private RebateCalOrderStrategy rebateCalOrderStrategy;

    @Resource
    private FreeCalOrderStrategy freeCalOrderStrategy;

    @Resource
    private OrderMinBuyNumHandler orderMinBuyNumHandler;

    @Resource
    private OrderPromotionHandler orderPromotionHandler;

    @Resource
    private OrderCalPriceHandler orderCalPriceHandler;

    @Resource
    private OrderUseFeeHandler orderUseFeeHandler;

    @Resource
    private OrderBackFeeHandler orderBackFeeHandler;

    @Resource
    private CrmLogSendUtil crmLogSendUtil;

    @Resource
    private OrderDetailPromotionService orderDetailPromotionService;

    @Resource
    private RedisService redisService;

    @Resource
    private RocketMQProducer rocketMQProducer;

    /**
     * 1、验证基本数据,并且将每个组的促销价格置零,重置每个组的促销金额
     * 2、定义变量
     * 3、起订量验证
     * 4、补全产品信息
     * 5、计算行价格
     * 6、行促销计算
     * 7、行货补费用计算
     * 8、总价计算
     * @param orderVo
     * @return
     */
    @Override
    public OrderVo cal(OrderVo orderVo,boolean orderFalg) {
        //1
        OrderValidateParamExcutor.validate(standerdOrderValidateParamStrategy,orderVo);
        orderVo.setCalSucessFlag(YesNoEnum.yesNoEnum.YES.getValue());

        //2
        String cusCode = orderVo.getCusCode();
        String orgCode = "";
        MdmCustomerMsgRespVo mdmCustomerMsgRespVo = ApiResultUtil.objResult(mdmCustomerMsgFeign.query(null, cusCode), true);
        orderVo.setCusOrgCode(mdmCustomerMsgRespVo.getOrgCode());
        orderVo.setCusOrgName(mdmCustomerMsgRespVo.getOrgName());
        orgCode = mdmCustomerMsgRespVo.getOrgCode();
        orderVo = orderUtil.createLineAndSort(orderVo);

        //3
        if(orderFalg){
            orderVo = orderMinBuyNumHandler.handle(orderVo,cusCode,orgCode);
            if(orderVo.getCalSucessFlag().equals(YesNoEnum.yesNoEnum.NO.getValue())){
                return orderUtil.createLineAndSort(orderVo);
            }
        }

        //4
        orderVo = CompletionProductMsgExcutor.completion(standerdCompletionProductMsgStrategy,orderVo,cusCode,orgCode);
        if(orderVo.getCalSucessFlag().equals(YesNoEnum.yesNoEnum.NO.getValue())){
            return orderUtil.createLineAndSort(orderVo);
        }


        //5
        orderVo = orderCalPriceHandler.cal(orderVo);


        //6
        orderVo = orderPromotionHandler.handle(orderVo,cusCode,orgCode);
        if(orderVo.getCalSucessFlag().equals(YesNoEnum.yesNoEnum.NO.getValue())){
            return orderUtil.createLineAndSort(orderVo);
        }

        //7
        orderVo = ValidateRebateFeeExcutor.validate(standerdOrderValidateFeeStategy,orderVo,cusCode,orgCode);
        if(orderVo.getCalSucessFlag().equals(YesNoEnum.yesNoEnum.NO.getValue())){
            return orderUtil.createLineAndSort(orderVo);
        }

        //8
        orderVo = CalOrderExcutor.cal(standerdCalOrderStrategy,orderVo,cusCode,orgCode);
        return orderUtil.createLineAndSort(orderVo);
    }

    /**
     * 1、验证基本数据
     * 2、定义变量
     * 3、补全产品信息
     * 4、计算行价格
     * 5、行货补费用计算(主要是检测)
     * 6、总价计算
     * @param orderVo
     * @return
     */
    @Override
    public OrderVo calForRebate(OrderVo orderVo) {
        //1
        OrderValidateParamExcutor.validate(rebateOrderValidateParamStrategy,orderVo);
        orderVo.setCalSucessFlag(YesNoEnum.yesNoEnum.YES.getValue());

        //2
        String cusCode = orderVo.getCusCode();
        String orgCode = "";
        MdmCustomerMsgRespVo mdmCustomerMsgRespVo = ApiResultUtil.objResult(mdmCustomerMsgFeign.query(null, cusCode), true);
        orderVo.setCusOrgCode(mdmCustomerMsgRespVo.getOrgCode());
        orderVo.setCusOrgName(mdmCustomerMsgRespVo.getOrgName());
        orgCode = mdmCustomerMsgRespVo.getOrgCode();
        orderVo = orderUtil.createLineAndSort(orderVo);

        //3
        orderVo = CompletionProductMsgExcutor.completion(rebateCompletionProductMsgStrategy,orderVo,cusCode,orgCode);
        if(orderVo.getCalSucessFlag().equals(YesNoEnum.yesNoEnum.NO.getValue())){
            return orderUtil.createLineAndSort(orderVo);
        }

        //4
        orderVo = orderCalPriceHandler.cal(orderVo);

        //5
        orderVo = ValidateRebateFeeExcutor.validate(rebateOrderValidateFeeStategy,orderVo,cusCode,orgCode);
        if(orderVo.getCalSucessFlag().equals(YesNoEnum.yesNoEnum.NO.getValue())){
            return orderUtil.createLineAndSort(orderVo);
        }

        //6
        orderVo = CalOrderExcutor.cal(rebateCalOrderStrategy,orderVo,cusCode,orgCode);
        return orderUtil.createLineAndSort(orderVo);
    }

    /**
     * 1、验证基本数据
     * 2、定义变量
     * 3、补全产品信息
     * 4、计算行价格
     * 5、总价计算
     * @param orderVo
     * @return
     */
    @Override
    public OrderVo calForFree(OrderVo orderVo) {
        //1
        OrderValidateParamExcutor.validate(freeOrderValidateParamStrategy,orderVo,1,"2",5);
        orderVo.setCalSucessFlag(YesNoEnum.yesNoEnum.YES.getValue());

        //2
        String cusCode = orderVo.getCusCode();
        String orgCode = "";
        MdmCustomerMsgRespVo mdmCustomerMsgRespVo = ApiResultUtil.objResult(mdmCustomerMsgFeign.query(null, cusCode), true);
        orderVo.setCusOrgCode(mdmCustomerMsgRespVo.getOrgCode());
        orderVo.setCusOrgName(mdmCustomerMsgRespVo.getOrgName());
        orgCode = mdmCustomerMsgRespVo.getOrgCode();
        orderVo = orderUtil.createLineAndSort(orderVo);

        //3
        orderVo = CompletionProductMsgExcutor.completion(freeCompletionProductMsgStrategy,orderVo,cusCode,orgCode);
        if(orderVo.getCalSucessFlag().equals(YesNoEnum.yesNoEnum.NO.getValue())){
            return orderUtil.createLineAndSort(orderVo);
        }

        //4
        orderVo = orderCalPriceHandler.cal(orderVo);

        //5
        orderVo = CalOrderExcutor.cal(freeCalOrderStrategy,orderVo,cusCode,orgCode);
        return orderUtil.createLineAndSort(orderVo);
    }

    /**
     * 1、先算价
     * 2、转换模型保存订单头
     * 3、保存订单详情
     * 4、保存订单附件
     * 5、保存订单促销
     * @param orderVo
     */
    @Transactional
    @Override
    public void temporaryAdd(OrderVo orderVo) {
        //1
        this.cal(orderVo,true);
        if(orderVo.getCalSucessFlag().equals(YesNoEnum.yesNoEnum.NO.getValue())){
            String msg = orderVo.getCalSucessMsg();
            if(StringUtils.isEmpty(orderVo.getCalSucessMsg())){
                msg = "订单条件不满足，请检查！";
            }
            throw new BusinessException(msg);
        }

        //2
        orderVo.setState(OrderEunm.STATE.TOSUBMIT.getCode());
        OrderEntity orderEntity = orderUtil.packageOrderHead(orderVo);
        orderEntity.setTemporaryFlag(YesNoEnum.yesNoEnum.YES.getValue());
        this.save(orderEntity);

        //3
        orderDetailService.addBatch(orderVo,orderEntity,true);

        //4
        orderFileService.replace(orderEntity.getOrderCode(),orderVo.getFiles());

        //5
        orderDetailPromotionService.rePlace(orderEntity,OrderUtil.extractPromotion(orderVo));
    }

    /**
     * 1、先查看订单是否存在
     * 2、先算价
     * 3、转换模型保存订单头
     * 4、保存订单详情
     * 5、保存订单附件
     * 6、保存订单促销
     * @param orderVo
     */
    @Override
    public void edit(OrderVo orderVo) {
        //1
        if(StringUtils.isEmpty(orderVo.getId())){
            throw new BusinessException("订单不存在!");
        }
        OrderEntity orderEntity = orderMapper.selectById(orderVo.getId());
        OrderVo oldObject = this.findDetailsById(orderVo.getId());
        //2
        String type = orderVo.getType();
        if(type.equals(OrderEunm.TYPE.STANDERD.getCode())){
            orderVo = this.cal(orderVo,true);
        }else if(type.equals(OrderEunm.TYPE.FREE.getCode())){
            orderVo = this.calForFree(orderVo);
        }else{
            orderVo = this.calForRebate(orderVo);
        }
        if(orderVo.getCalSucessFlag().equals(YesNoEnum.yesNoEnum.NO.getValue())){
            String msg = orderVo.getCalSucessMsg();
            if(StringUtils.isEmpty(orderVo.getCalSucessMsg())){
                msg = "订单条件不满足，请检查！";
            }
            throw new BusinessException(msg);
        }

        //3
        orderEntity = orderUtil.packageOrderHeadForEndit(orderVo,orderEntity);
        this.updateById(orderEntity);

        //4
        orderDetailService.editBatch(orderVo,orderEntity,orderVo.getTemporaryFlag().equals(YesNoEnum.yesNoEnum.YES.getValue())?false:true);

        //5
        orderFileService.replace(orderEntity.getOrderCode(),orderVo.getFiles());

        //6
        //5
        orderDetailPromotionService.rePlace(orderEntity,OrderUtil.extractPromotion(orderVo));

        OrderVo newObject = this.findDetailsById(orderVo.getId());
        Object menuCodeObj = ThreadLocalUtil.getObj(GlobalParam.MENU_CODE);
        if (menuCodeObj != null) {
            crmLogSendUtil.sendForUpdate(menuCodeObj.toString(), newObject.getId(),newObject.getId(),oldObject,newObject);
        }

    }

    /**
     * 1、判断是否是攒存单，如果是暂存单，则删掉暂存单
     * 2、先算价
     * 3、转换模型保存订单头
     * 4、保存订单详情
     * 5、保存订单附件
     * 6、费用扣减
     * 7、保存订单促销
     * 8、通知促销，订单促销使用情况
     * @param orderVo
     */
    @Transactional
    @Override
    public void add(OrderVo orderVo) {
        //1
        if(orderVo.getTemporaryFlag().equals(YesNoEnum.yesNoEnum.YES.getValue())){
            this.delByOrderCode(orderVo.getOrderCode());
        }

        //2
        orderVo = this.cal(orderVo,true);
        if(orderVo.getCalSucessFlag().equals(YesNoEnum.yesNoEnum.NO.getValue())){
            String msg = orderVo.getCalSucessMsg();
            if(StringUtils.isEmpty(orderVo.getCalSucessMsg())){
                msg = "订单条件不满足，请返回检查订单行错误信息！";
            }
            throw new BusinessException(msg);
        }

        //3
        orderVo.setState(OrderEunm.STATE.TOAPPROVAL.getCode());
        orderVo.setId("");
        OrderEntity orderEntity = orderUtil.packageOrderHead(orderVo);
        orderEntity.setTemporaryFlag(YesNoEnum.yesNoEnum.NO.getValue());
        this.save(orderEntity);

        //4
        List<OrderDetailEntity> detailEntities = orderDetailService.addBatch(orderVo,orderEntity,true);

        //5
        orderFileService.replace(orderEntity.getOrderCode(),orderVo.getFiles());

        //6
        orderUseFeeHandler.hand(orderEntity,detailEntities);
        //7
        orderDetailPromotionService.rePlace(orderEntity,OrderUtil.extractPromotion(orderVo));

        Object menuCodeObj = ThreadLocalUtil.getObj(GlobalParam.MENU_CODE);
        OrderVo detailsById = findDetailsById(orderEntity.getId());
        if (menuCodeObj != null) {
            crmLogSendUtil.sendForAdd(menuCodeObj.toString(),detailsById.getId(),detailsById.getId(),detailsById);
        }

        //8
        DmsPromotionPolicyOrderDetailReqVo reqVo = new DmsPromotionPolicyOrderDetailReqVo();
        reqVo.setCustomerCode(orderEntity.getCusCode());
        reqVo.setCustomerName(orderEntity.getCusName());

        //9、保存促销政策赠品使用数量(redis)
        OrderUtil.saveGiftCount(orderVo, redisService);

        //10、清空已购买购物车商品
        this.clearShoppingCar(orderVo);
    }

    /**
     * 清空已购买购物车商品
     * @param orderVo
     */
    private void clearShoppingCar(OrderVo orderVo) {
        if(!Objects.equals(orderVo.getFromType(), FromTypeEunm.fromTypeEunm.PC.getCode())
        && !Objects.equals(orderVo.getFromType(), FromTypeEunm.fromTypeEunm.WX.getCode())) {
            return;
        }
        RocketMQMessageBody msg = new RocketMQMessageBody();
        msg.setTag(RocketMQConstant.CRM_MQ_TAG.CLEAR_SHOPPING_CAR);
        msg.setMsgBody(JSON.toJSONString(orderVo));
        rocketMQProducer.convertAndSend(msg);
    }


    /**
     * 1、先算价
     * 2、转换模型保存订单头
     * 3、保存订单详情
     * 4、保存订单附件
     * 5、费用扣减
     * @param orderVo
     */
    @Override
    public void addForRebate(OrderVo orderVo) {
        //1
        orderVo = this.calForRebate(orderVo);
        if(orderVo.getCalSucessFlag().equals(YesNoEnum.yesNoEnum.NO.getValue())){
            String msg = orderVo.getCalSucessMsg();
            if(StringUtils.isEmpty(orderVo.getCalSucessMsg())){
                msg = "订单条件不满足，请返回检查订单行错误信息！";
            }
            throw new BusinessException(msg);
        }

        //2
        orderVo.setState(OrderEunm.STATE.TOAPPROVAL.getCode());
        orderVo.setId("");
        OrderEntity orderEntity = orderUtil.packageOrderHead(orderVo);
        orderEntity.setTemporaryFlag(YesNoEnum.yesNoEnum.NO.getValue());
        this.save(orderEntity);

        //3
        List<OrderDetailEntity> detailEntities = orderDetailService.addBatch(orderVo,orderEntity,true);

        //4
        orderFileService.replace(orderEntity.getOrderCode(),orderVo.getFiles());

        //5
        orderUseFeeHandler.hand(orderEntity,detailEntities);

        Object menuCodeObj = ThreadLocalUtil.getObj(GlobalParam.MENU_CODE);
        OrderVo detailsById = findDetailsById(orderEntity.getId());
        if (menuCodeObj != null) {
            crmLogSendUtil.sendForAdd(menuCodeObj.toString(),detailsById.getId(),detailsById.getId(),detailsById);
        }
    }


    /**
     * 1、先算价
     * 2、转换模型保存订单头
     * 3、保存订单详情
     * 4、保存订单附件
     * @param orderVo
     */
    @Override
    public void addForFree(OrderVo orderVo) {
        //1
        orderVo = this.calForFree(orderVo);
        if(orderVo.getCalSucessFlag().equals(YesNoEnum.yesNoEnum.NO.getValue())){
            String msg = orderVo.getCalSucessMsg();
            if(StringUtils.isEmpty(orderVo.getCalSucessMsg())){
                msg = "订单条件不满足，请返回检查订单行错误信息！";
            }
            throw new BusinessException(msg);
        }

        //2
        orderVo.setState(OrderEunm.STATE.TOAPPROVAL.getCode());
        orderVo.setId("");
        OrderEntity orderEntity = orderUtil.packageOrderHead(orderVo);
        orderEntity.setTemporaryFlag(YesNoEnum.yesNoEnum.NO.getValue());
        this.save(orderEntity);

        //3
        orderDetailService.addBatch(orderVo,orderEntity,true);

        //4
        orderFileService.replace(orderEntity.getOrderCode(),orderVo.getFiles());

        Object menuCodeObj = ThreadLocalUtil.getObj(GlobalParam.MENU_CODE);
        OrderVo detailsById = findDetailsById(orderEntity.getId());
        if (menuCodeObj != null) {
            crmLogSendUtil.sendForAdd(menuCodeObj.toString(),detailsById.getId(),detailsById.getId(),detailsById);
        }
    }

    /**
     * 1、验证
     * 2、删除订单
     * 3、删除订单行
     * 4、删除订单文件
     * 5、删除订单促销
     * @param orderCode
     */
    @Override
    public void delByOrderCode(String orderCode) {
        //1
        if(StringUtils.isEmpty(orderCode)){
           return;
        }

        //2
        QueryWrapper<OrderEntity> wrapper = new QueryWrapper<>();
        wrapper.eq("order_code", orderCode);

        Object menuCodeObj = ThreadLocalUtil.getObj(GlobalParam.MENU_CODE);
        OrderEntity entity = orderMapper.selectOne(wrapper);
        OrderVo detailsById = findDetailsById(entity.getId());
        if (menuCodeObj != null) {
            crmLogSendUtil.sendForDel(menuCodeObj.toString(),detailsById.getId(),detailsById.getId(),detailsById);
        }

        orderMapper.delete(wrapper);

        //3
        orderDetailService.deleteByOrderCode(orderCode);

        //4
        orderFileService.deleteByOrderCode(orderCode);

        //5
        orderDetailPromotionService.delByOrderCode(orderCode);
    }

    /**
     * 1、验证
     * 2、退单
     * 3、批量查询订单并且退费用
     * @param ids
     */
    @Override
    public void cancel(List<String> ids) {
        //1
        if(CollectionUtils.isEmpty(ids)){
            return;
        }

        //2
        this.updateStateByIds(ids,OrderEunm.STATE.CANCEL);

        //3
        List<OrderEntity> orderEntities = orderMapper.selectBatchIds(ids);
        if(CollectionUtils.isEmpty(orderEntities)){
            return;
        }
        orderBackFeeHandler.hand(orderEntities);
        ids.forEach(id -> {
            //4、扣除本单使用的赠品
            OrderVo orderVo = this.findSimpleDetailsById(id);
            OrderUtil.reduceGiftCount(orderVo, redisService);
        });

    }

    /**
     * 根据id批量取消订单
     * 1、参数验证
     * 2、验证订单是否存在
     * 3、修改订单状态
     * @param ids
     */
    @Transactional
    @Override
    public void updateStateByIds(List<String> ids,OrderEunm.STATE state) {
        if (CollectionUtils.isEmpty(ids)) {
            return;
        }
        orderMapper.updateStateByIds(state.getCode(),ids);
    }

    /**
     * 根据订单id查询详情
     * 1、校验入参
     * 2、查询订单主数据
     * 3、查询订单文件
     * 4、查询订单明细
     * 5、查询订单促销 并 处理
     * 5、算价
     * @param id
     * @return
     */
    @Override
    public OrderVo findDetailsById(String id) {
        //1、
        if(StringUtils.isEmpty(id)) {
            return null;
        }
        //2、
        OrderEntity entity = this.orderMapper.selectById(id);
        OrderVo vo = CrmBeanUtil.copy(entity, OrderVo.class);
        if(vo == null) {
            return null;
        }
        //3、
        List<OrderFileVo> files = this.orderFileService.findByOrderCode(vo.getOrderCode());
        vo.setFiles(files);

        //4、
        List<OrderGroupItemVo> groupItemVos = this.orderDetailService.findGroupByOrderCode(vo.getOrderCode());
        vo.setGroupItemVos(groupItemVos);

        //5
        List<OrderDetailPromotionVo> promotionVos = orderDetailPromotionService.findPromotionByOrderCode(vo.getOrderCode());
        OrderUtil.packagePromotionToVo(vo,promotionVos);

        String type = entity.getType();
        if(type.equals(OrderEunm.TYPE.STANDERD.getCode())){
            return this.cal(vo, false);
        }else if(type.equals(OrderEunm.TYPE.FREE.getCode())){
            return this.calForFree(vo);
        }else{
            return this.calForRebate(vo);
        }
    }

    /**
     * 根据编码查询详情
     * 1、校验入参
     * 2、查询订单主数据
     * 3、查询订单文件
     * 4、查询订单明细
     * @param orderCode
     * @return
     */
    @Override
    public OrderVo findDetailByCode(String orderCode) {
        //1、
        if(StringUtils.isEmpty(orderCode)) {
            return null;
        }

        //2、
        OrderEntity entity = this.orderMapper.selectOne(Wrappers.<OrderEntity>query().eq("order_code", orderCode));
        OrderVo vo = CrmBeanUtil.copy(entity, OrderVo.class);
        if(vo == null) {
            return null;
        }

        //3、
        List<OrderFileVo> files = this.orderFileService.findByOrderCode(vo.getOrderCode());
        vo.setFiles(files);

        //4、
        List<OrderGroupItemVo> groupItemVos = this.orderDetailService.findGroupByOrderCode(vo.getOrderCode());
        vo.setGroupItemVos(groupItemVos);

        //5
        List<OrderDetailPromotionVo> promotionVos = orderDetailPromotionService.findPromotionByOrderCode(vo.getOrderCode());
        OrderUtil.packagePromotionToVo(vo,promotionVos);

        return vo;
    }

    /**
     * 根据id查询详情（不询价）
     * @param id
     * @return
     */
    @Override
    public OrderVo findSimpleDetailsById(String id) {
        //1、
        if(StringUtils.isEmpty(id)) {
            return null;
        }
        //2、
        OrderEntity entity = this.orderMapper.selectById(id);
        OrderVo vo = CrmBeanUtil.copy(entity, OrderVo.class);
        if(vo == null) {
            return null;
        }
        //3、
        List<OrderFileVo> files = this.orderFileService.findByOrderCode(vo.getOrderCode());
        vo.setFiles(files);
        //4、
        List<OrderGroupItemVo> groupItemVos = this.orderDetailService.findGroupByOrderCode(vo.getOrderCode());
        vo.setGroupItemVos(groupItemVos);
        //5
        List<OrderDetailPromotionVo> promotionVos = orderDetailPromotionService.findPromotionByOrderCode(vo.getOrderCode());
        OrderUtil.packagePromotionToVo(vo,promotionVos);
        return vo;
    }

    /**
     * 1、先算价
     * 2、汇总
     * @param orderVo
     * @return
     */
    @Override
    public OrderVo collect(OrderVo orderVo) {
        //1
        orderVo = this.cal(orderVo,false);
        if(orderVo.getCalSucessFlag().equals(YesNoEnum.yesNoEnum.NO.getValue())){
            String msg = orderVo.getCalSucessMsg();
            if(StringUtils.isEmpty(orderVo.getCalSucessMsg())){
                msg = "订单条件不满足，请返回检查订单行错误信息！";
            }
            throw new BusinessException(msg);
        }

        //2
        OrderUtil.collect(orderVo);

        return orderVo;
    }

    /**
     * 通过查询条件批量查询
     * 1、设置查询条件
     * 2、查询结果
     * @param orderVo 查询条件
     * @return
     */
    @Override
    public PageResult<OrderVo> listByConditions(OrderVo orderVo) {
        //补全查询日期
        if (StringUtils.isNotEmpty(orderVo.getBeginDate())) {
            orderVo.setBeginDate(orderVo.getBeginDate() + " 00:00:00");
        }
        if (StringUtils.isNotEmpty(orderVo.getEndDate())) {
            orderVo.setEndDate(orderVo.getEndDate() + " 23:59:59");
        }
        //1
        Page<OrderVo> page = new Page<>(orderVo.getPageNum(), orderVo.getPageSize());
        //2
        List<OrderVo> list = orderMapper.pageList(page, orderVo);
        return PageResult.<OrderVo>builder().data(list).count(page.getTotal()).build();
    }

    /**
     * 批量删除暂存订单
     * 1、校验入参
     * 2、校验客户
     * 3、逐条订单校验是否暂存订单、是否属于当前客户
     * 4、删除订单明细
     * 5、删除订单文件
     * 6、删除订单
     * @param ids
     */
    @Override
    @Transactional
    public void deleteByIds(List<String> ids) {
        //1、
        ValidateUtils.notEmpty(ids, "参数不能为空");
        //2、
        UserRedis user = UserUtils.getUser();
        ValidateUtils.validate(user, "没有获取到当前登录用户，请重新登录");
        ValidateUtils.validate(user.getCustcode(), "当前登录用户没有客户编码，请确认操作者身份和权限是否正确");
        List<String> orderCodes = Lists.newArrayList();
        //3、
        for(int i = 0; i < ids.size(); i++) {
            OrderEntity entity = this.baseMapper.selectById(ids.get(i));
            ValidateUtils.validate(entity, "传入的第%d个订单不存在", i);
            ValidateUtils.isTrue(Objects.equals(user.getCustcode(), entity.getCusCode()), "传入的第%d个订单不属于当前登录用户【%s】，不能删除", i, user.getCustcode());
            ValidateUtils.isTrue(Objects.equals(YesNoEnum.yesNoEnum.YES.getValue(), entity.getTemporaryFlag()), "传入的第%d个订单【订单号：%s】不是暂存单，不能删除", i, entity.getOrderCode());
            orderCodes.add(entity.getOrderCode());
        }
        //4、
        this.orderDetailService.deleteByOrderCodes(orderCodes);
        //5、
        this.orderFileService.deleteByOrderCodes(orderCodes);
        //6、
        this.orderMapper.deleteBatchIds(ids);
    }

}
