package com.biz.crm.order.tools.handler;

import com.biz.crm.base.BusinessException;
import com.biz.crm.eunm.YesNoEnum;
import com.biz.crm.eunm.fee.FeePoolOperationTypeEnum;
import com.biz.crm.fee.pool.FeePoolFeign;
import com.biz.crm.nebular.fee.pool.req.FeePoolUseBackAllReqVo;
import com.biz.crm.order.OrderEntity;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

import java.util.ArrayList;
import java.util.List;

/**
 * @Description: 订单回退费用
 * @Author: zhangyuzhu
 * @Date: 2021/3/17 11:35
 **/
@ConditionalOnMissingBean(name = "orderBackFeeHandlerExpand")
@Component("orderBackFeeHandler")
public class OrderBackFeeHandler {

    @Autowired
    private FeePoolFeign feePoolFeign;

    /**
     * 处理
     * 1、组装参数
     * 2、扣费用
     * @param orderEntities
     * @return
     */
    public void hand(List<OrderEntity> orderEntities){
        List<FeePoolUseBackAllReqVo> params = new ArrayList<>();
        for(OrderEntity order : orderEntities){
            //暂存单不回退费用
            if(order.getTemporaryFlag().equals(YesNoEnum.yesNoEnum.NO.getValue())){
                FeePoolUseBackAllReqVo feePoolUseBackAllReqVo = new FeePoolUseBackAllReqVo();
                feePoolUseBackAllReqVo.setFromCode(order.getOrderCode());
                feePoolUseBackAllReqVo.setOperationType(FeePoolOperationTypeEnum.ORDER_BACK.getValue());
                params.add(feePoolUseBackAllReqVo);
            }
        }
        if(CollectionUtils.isEmpty(params)){
            return;
        }
        if(!feePoolFeign.backAllUseByFromCodeBatch(params).isSuccess()){
            throw new BusinessException("费用回退失败，请查看费用池");
        }
    }

}
