package com.biz.crm.order.tools.strategy.calpromotion.impl;

import com.biz.crm.base.BusinessException;
import com.biz.crm.dms.promotion.PromotionV2Feign;
import com.biz.crm.eunm.YesNoEnum;
import com.biz.crm.eunm.dms.OrderEunm;
import com.biz.crm.eunm.dms.PromotionPolicyEunm;
import com.biz.crm.nebular.dms.npromotion.vo.CalculateHitResultVo;
import com.biz.crm.nebular.dms.npromotion.vo.PromotionEditVo;
import com.biz.crm.nebular.dms.npromotion.vo.PromotionProductVo;
import com.biz.crm.nebular.dms.npromotion.vo.PromotionQueryReq;
import com.biz.crm.nebular.dms.npromotion.vo.PromotionSaleProductVo;
import com.biz.crm.nebular.order.OrderDetailPromotionVo;
import com.biz.crm.nebular.order.OrderDetailVo;
import com.biz.crm.nebular.order.OrderGroupItemVo;
import com.biz.crm.nebular.order.OrderVo;
import com.biz.crm.order.tools.strategy.calpromotion.CalPromotionStrategy;
import com.biz.crm.order.utils.OrderUtil;
import com.biz.crm.util.CollectionUtil;
import com.biz.crm.util.Result;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

import java.math.BigDecimal;
import java.util.*;

/**
 * @Description:
 * @Author: zhangyuzhu
 * @Date: 2021/5/8 11:20
 **/
@ConditionalOnMissingBean(name = "buyAndGiftCalPromotionStrategyExpand")
@Component("buyAndGiftCalPromotionStrategy")
public class BuyAndGiftCalPromotionStrategy implements CalPromotionStrategy {

    @Autowired
    private PromotionV2Feign promotionV2Feign;

    /**
     * 1、验证参数
     * 2、找出所有的买赠促销，并且组装促销参数
     * 3、查询所有的促销
     * 4、挨个计算买赠促销
     * @param orderVo
     * @param cusCode
     * @param orgCode
     * @param objects
     * @return
     */
    @Override
    public OrderVo cal(OrderVo orderVo, String cusCode, String orgCode,Integer calNum, Object... objects) {
        //1
        validateParam(orderVo);
        if(!OrderUtil.judegeOrder(orderVo)){
            return orderVo;
        }

        //2
        ArrayList<PromotionQueryReq> param = packageParam(orderVo,cusCode,orgCode,objects);
        if(CollectionUtils.isEmpty(param)){
            return orderVo;
        }

        //3
        Result<Map<String,PromotionEditVo>> result = promotionV2Feign.findHitPromotionMapByPromotionCodes(param);
        if(!result.isSuccess()){
            throw new BusinessException("促销服务正在重启，请联系管理员");
        }
        Map<String,PromotionEditVo> promotionMap = result.getResult();

        //4
        return cal(orderVo,promotionMap,calNum);
    }

    /**
     * 计算
     * 1、验证促销是否存在
     * 2、验证促销是否是行上可重复
     * 3、验证促销匹配阶梯是否报错
     * 4、验证促销赠品是否正确
     * 5、计算促销总金额，为祖上和行上促销赋值
     * @param orderVo
     * @param promotionMap
     * @return
     */
    public static OrderVo cal(OrderVo orderVo, Map<String,PromotionEditVo> promotionMap,Integer calNum){
        for(OrderGroupItemVo group : orderVo.getGroupItemVos()){
            if(group.getBuyAndGiveFlag().equals(YesNoEnum.yesNoEnum.NO.getValue())){
                continue;
            }

            //1
            PromotionEditVo promotionEditVo = promotionMap.get(group.getPromotionCode());
            if(null == promotionEditVo){
                orderVo.setCalSucessFlag(YesNoEnum.yesNoEnum.NO.getValue());
                orderVo.setCalSucessMsgType(OrderEunm.calSucessMsgTypeEnum.PROMOTION.getCode());
                StringBuilder stb = new StringBuilder("提示：促销【")
                        .append(group.getPromotionName())
                        .append("】不存在或已过期");
                zPromotionError(group,stb.toString(),group.getPromotionCode());
                return orderVo;
            }

            //2
            if(promotionEditVo.getMultipleable().equals(YesNoEnum.yesNoEnum.NO.getValue())
                    && judegeNum(group,promotionEditVo.getPromotionPolicyCode())){
                orderVo.setCalSucessFlag(YesNoEnum.yesNoEnum.NO.getValue());
                orderVo.setCalSucessMsgType(OrderEunm.calSucessMsgTypeEnum.PROMOTION.getCode());
                StringBuilder stb = new StringBuilder("提示：促销【")
                        .append(group.getPromotionName())
                        .append("】不能叠加");
                zPromotionError(group,stb.toString(),group.getPromotionCode());
            }


            //3
            if(!promotionEditVo.isMatchState()){
                orderVo.setCalSucessFlag(YesNoEnum.yesNoEnum.NO.getValue());
                orderVo.setCalSucessMsgType(OrderEunm.calSucessMsgTypeEnum.PROMOTION.getCode());
                zPromotionError(group,promotionEditVo.getMatchMsg(),group.getPromotionCode());
                return orderVo;
            }

            //4
            List<PromotionProductVo> gifts = promotionEditVo.getProductMap().get("giftProducts");
            if(CollectionUtils.isEmpty(gifts) || CollectionUtil.listEmpty(group.getGiftList())){
                //如果促销没得赠品，则去掉赠品
                group.setGiftList(new ArrayList<>());
            }
            //如果赠品中实际商品跟促销不一致，则报错
            boolean judegeFlag = validateGiftGoods(gifts,group);
            if(!judegeFlag){
                orderVo.setCalSucessFlag(YesNoEnum.yesNoEnum.NO.getValue());
                orderVo.setCalSucessMsgType(OrderEunm.calSucessMsgTypeEnum.LINE.getCode());
                return orderVo;
            }
            //设置赠品数量，如果赠品数量全部为null，则按比例分配最大赠送量
            if(gifts == null) gifts = Lists.newArrayList();
            Map<String, PromotionProductVo> giftMap = gifts.stream().collect(
                    Collectors.toMap(PromotionProductVo::getProductCode, a -> a, (a, b) -> a)
            );
            boolean defaultGift = false;
            for (OrderDetailVo detailVo : group.getGiftList()) {
                if(detailVo.getProductNum() == null) {
                    defaultGift = true;
                    break;
                }
            }
            CalculateHitResultVo calculate = promotionEditVo.getCalculateHitResultVo();
            if(defaultGift && calculate != null && calculate.getValue() != null && calculate.getValueType() != null) {
                for (OrderDetailVo detailVo : group.getGiftList()) {
                    PromotionProductVo promotionProductVo = giftMap.get(detailVo.getProductCode());
                    if(promotionProductVo == null) {
                        continue;
                    }
                    if("number".equals(calculate.getValueType())) {
                        detailVo.setProductNum(promotionProductVo.getGiftCountMax());
                    } else if("amount".equals(calculate.getValueType())) {
                        BigDecimal amount = promotionProductVo.getGiftAmountMax();
                        if(amount != null && detailVo.getPrice() != null && detailVo.getPrice().compareTo(BigDecimal.ZERO) != 0) {
                            BigDecimal count = amount.divide(detailVo.getPrice(), 0, BigDecimal.ROUND_FLOOR);
                            detailVo.setProductNum(count);
                        }
                    }
                }
                //设置赠品金额
                if(!CollectionUtils.isEmpty(group.getGiftList()) && defaultGift){
                    for(OrderDetailVo item : group.getGiftList()){
                        item.setAmount(item.getPrice().multiply(
                                item.getProductNum()
                        ).setScale(6,BigDecimal.ROUND_HALF_UP));
                    }
                }
                //如果政策赠送的是金额，计算出的数量可能有误差，所以进行数据补全,TODO 好像没法补全
//                if("amount".equals(calculate.getValueType())) {
//                    BigDecimal sum = BigDecimal.ZERO;
//                    for (OrderDetailVo detailVo : group.getGiftList()) {
//                        sum = sum.add(detailVo.getProductNum() == null ? BigDecimal.ZERO : detailVo.getProductNum());
//                    }
//                    if(CollectionUtil.listNotEmpty(group.getGiftList())) {
//                        OrderDetailVo detailVo = group.getGiftList().get(0);
//                        detailVo.setProductNum((detailVo.getProductNum() == null ? BigDecimal.ZERO : detailVo.getProductNum())
//                        .add())
//                    }
//                }
            }


            //5
            calPrice(group,promotionEditVo,calNum);
            if(!OrderUtil.judegeOrderGroup(group)){
                orderVo.setCalSucessFlag(YesNoEnum.yesNoEnum.NO.getValue());
                orderVo.setCalSucessMsgType(OrderEunm.calSucessMsgTypeEnum.GROUP.getCode());
                return orderVo;
            }
        }
        return orderVo;
    }

    /**
     * 设置促销错误
     * @param group
     * @param msg
     * @param promotionCode
     */
    public static void zPromotionError(OrderGroupItemVo group,String msg,String promotionCode){
        for(OrderDetailVo detail : group.getNormalList()){
            if(CollectionUtils.isEmpty(detail.getPromotionVos())){
                continue;
            }
            for(OrderDetailPromotionVo promotion : detail.getPromotionVos()){
                if(promotion.getPromotionCode().equals(promotionCode)){
                    promotion.setCalSucessFlag(YesNoEnum.yesNoEnum.NO.getValue());
                    promotion.setCalSucessMsg(msg);
                }
            }
        }
    }

    /**
     * 计算促销
     * 1、设置买赠促销信息
     * 2、计算赠品价值
     * 3、验证赠品是否超过价值了
     * @param group
     * @param promotionEditVo
     */
    public static void calPrice(OrderGroupItemVo group,PromotionEditVo promotionEditVo,Integer calNum){
        //1
        BigDecimal promotionAmount = BigDecimal.ZERO;
        BigDecimal promotionNum = BigDecimal.ZERO;
        if(!CollectionUtils.isEmpty(group.getGiftList())){
            for(OrderDetailVo gift : group.getGiftList()){
                promotionAmount = promotionAmount.add(
                        gift.getProductNum()
                                .multiply(gift.getPrice()).setScale(6, BigDecimal.ROUND_HALF_UP)
                );
                promotionNum = promotionNum.add(gift.getProductNum());
            }
        }
        if(group.getPromotionAmount() == null){
            group.setPromotionAmount(BigDecimal.ZERO);
        }
        group.setPromotionAmount(group.getPromotionAmount().add(promotionAmount));

        //2
        group.setPromotionName(promotionEditVo.getPromotionPolicyName());
        for(OrderDetailVo detail : group.getNormalList()){
            if(CollectionUtils.isEmpty(detail.getPromotionVos())){
                continue;
            }
            for(OrderDetailPromotionVo promotion : detail.getPromotionVos()){
                if(promotion.getPromotionCode().equals(promotionEditVo.getPromotionPolicyCode())){
                    promotion.setPromotionName(promotionEditVo.getPromotionPolicyName());
                    promotion.setPromotionType(promotionEditVo.getPromotionType());
                    promotion.setPromotionPolicyId(promotionEditVo.getId());
                    promotion.setSortNum(calNum);
                    promotion.setPromotionAmount(group.getPromotionAmount());
                    promotion.setPromotionDes("买赠活动本品金额不变，赠品价值详情请看赠品！");
                }
            }
        }


        //3
        StringBuilder stb = new StringBuilder();
        if(promotionEditVo.getCalculateHitResultVo().getValueType().equals("number")){
            stb.append("赠品可选数量【")
                    .append(promotionEditVo.getCalculateHitResultVo().getValue())
                    .append("】,已选【")
                    .append(promotionNum)
                    .append("】,");
            //还未满顶额
            if(promotionEditVo.getCalculateHitResultVo().getValue().compareTo(promotionNum) >= 0){
                stb.append("还可以选择【")
                        .append(promotionEditVo.getCalculateHitResultVo().getValue().subtract(promotionNum))
                        .append("】");
                group.setBuyAndGiveMsg(stb.toString());
            }else {
                stb.append("已超出");
                group.setBuyAndGiveMsg(stb.toString());
                group.setCalSucessFlag(YesNoEnum.yesNoEnum.NO.getValue());
                group.setCalSucessMsg(stb.toString());
            }
        }else {
            stb.append("赠品可选金额【")
                    .append(promotionEditVo.getCalculateHitResultVo().getValue())
                    .append("】,已选【")
                    .append(promotionAmount)
                    .append("】,");
            //还未满顶额
            if(promotionEditVo.getCalculateHitResultVo().getValue().compareTo(promotionAmount) >= 0){
                stb.append("还可以选择【")
                        .append(promotionEditVo.getCalculateHitResultVo().getValue().subtract(promotionAmount))
                        .append("】");
                group.setBuyAndGiveMsg(stb.toString());
            }else {
                stb.append("已超出");
                group.setBuyAndGiveMsg(stb.toString());
                group.setCalSucessFlag(YesNoEnum.yesNoEnum.NO.getValue());
                group.setCalSucessMsg(stb.toString());
            }
        }
        group.setBuyAndGiveMsg(stb.toString());
    }

    /**
     * 验证赠品商品是否一致(页面上可以比促销少，但是不能比促销多)
     * @return 如果为null 代表验证通过
     */
    public static boolean validateGiftGoods(List<PromotionProductVo> promotionGifts,OrderGroupItemVo group){
        if(CollectionUtils.isEmpty(group.getGiftList())){
            return true;
        }
        for(OrderDetailVo detail : group.getGiftList()){
            if(!exsitProductByCode(detail.getProductCode(),promotionGifts)){
                detail.setCalSucessFlag(YesNoEnum.yesNoEnum.NO.getValue());
                StringBuilder stb = new StringBuilder("提示：没有该项赠品或赠品已改变，请重新选择");
                detail.setCalSucessMsg(stb.toString());
                return false;
            }
        }
        return true;
    }

    /**
     * 通过产品Code，验证促销赠品是否存在促销中
     * @param productCode
     * @param promotionGifts
     * @return
     */
    public static boolean exsitProductByCode(String productCode,List<PromotionProductVo> promotionGifts){
        if(StringUtils.isEmpty(productCode)){
            return true;
        }
        if(CollectionUtils.isEmpty(promotionGifts)){
            return false;
        }
        for(PromotionProductVo promotionProductVo : promotionGifts){
            if(promotionProductVo.getProductCode().equals(productCode)){
                return true;
            }
        }
        return false;
    }

    /**
     * 验证块中促销是否叠加
     * @param group
     * @param promotionCode
     * @return
     */
    public static boolean judegeNum(OrderGroupItemVo group, String promotionCode){
        if(CollectionUtils.isEmpty(group.getNormalList())){
            return false;
        }
        for(OrderDetailVo detail : group.getNormalList()){
            if(CollectionUtils.isEmpty(detail.getPromotionVos()) || detail.getPromotionVos().size() == 1){
                continue;
            }
            for(OrderDetailPromotionVo promotionVo : detail.getPromotionVos()){
                if(promotionCode.equals(promotionVo.getPromotionCode())){
                    return true;
                }
            }
        }
        return false;
    }


    /**
     * 组装查询促销的参数
     * @param orderVo
     * @param cusCode
     * @param orgCode
     * @param objects
     */
    public static ArrayList<PromotionQueryReq> packageParam(OrderVo orderVo, String cusCode, String orgCode, Object... objects){
        ArrayList<PromotionQueryReq> reList = new ArrayList<>();
        for(OrderGroupItemVo group : orderVo.getGroupItemVos()){
            if(group.getBuyAndGiveFlag().equals(YesNoEnum.yesNoEnum.NO.getValue())){
                continue;
            }
            PromotionQueryReq req = new PromotionQueryReq();
            req.setAccountCode(cusCode);
            req.setAccountType("customer");
            List<PromotionSaleProductVo> saleProductVos = new ArrayList<>();
            List<String> promotionCodes = new ArrayList<>();
            promotionCodes.add(group.getPromotionCode());
            req.setPromotionCodes(promotionCodes);
            for(OrderDetailVo detail : group.getNormalList()){
                if(CollectionUtils.isEmpty(detail.getPromotionVos())){
                    continue;
                }
                for(OrderDetailPromotionVo promotion : detail.getPromotionVos()){
                    if(!promotion.getPromotionType().equals(PromotionPolicyEunm.PromotionTypeEunm.BUYGIFT.getCode())){
                        continue;
                    }
                    PromotionSaleProductVo product = new PromotionSaleProductVo();
                    product.setProductCode(detail.getProductCode());
                    product.setBuyCount(detail.getProductNum());
                    product.setBuyAmount(detail.getAmount());
                    product.setPrice(detail.getPrice());
                    saleProductVos.add(product);
                }
            }
            req.setSaleProductVos(saleProductVos);
            reList.add(req);
        }
        return reList;
    }


    /**
     * 检查参数：
     * 1、普通模块没有买赠促销
     * 2、同一个模块不能出现多个买赠
     * 3、买赠模块必须有买赠，并且必须和块上的促销一致
     * 4、痛一个订单买赠不能重复
     * @param orderVo
     */
    public static OrderVo validateParam(OrderVo orderVo){
        for(OrderGroupItemVo group : orderVo.getGroupItemVos()){
            //普通模块
            if(group.getBuyAndGiveFlag().equals(YesNoEnum.yesNoEnum.NO.getValue())){
                for(OrderDetailVo detail : group.getNormalList()){
                    if(CollectionUtils.isEmpty(detail.getPromotionVos())){
                        continue;
                    }
                    for(OrderDetailPromotionVo promotion : detail.getPromotionVos()){
                        if(promotion.getPromotionType().equals(PromotionPolicyEunm.PromotionTypeEunm.BUYGIFT.getCode())){
                            orderVo.setCalSucessFlag(YesNoEnum.yesNoEnum.NO.getValue());
                            orderVo.setCalSucessMsgType(OrderEunm.calSucessMsgTypeEnum.GROUP.getCode());
                            group.setCalSucessFlag(YesNoEnum.yesNoEnum.NO.getValue());
                            StringBuilder stb = new StringBuilder("提示：错误订单，普通块出现买赠促销");
                            group.setCalSucessMsg(stb.toString());
                            return orderVo;
                        }
                    }
                }
                group.setGiftList(new ArrayList<>());
            }else {
                //买赠块
                Set<String> promotionCodeSet = new HashSet<>();
                for(OrderDetailVo detail : group.getNormalList()){
                    if(CollectionUtils.isEmpty(detail.getPromotionVos())){
                        continue;
                    }
                    for(OrderDetailPromotionVo promotion : detail.getPromotionVos()){
                        if(promotion.getPromotionType().equals(PromotionPolicyEunm.PromotionTypeEunm.BUYGIFT.getCode())){
                            promotionCodeSet.add(promotion.getPromotionCode());
                        }
                    }
                }
                if(promotionCodeSet.size() == 0){
                    orderVo.setCalSucessFlag(YesNoEnum.yesNoEnum.NO.getValue());
                    orderVo.setCalSucessMsgType(OrderEunm.calSucessMsgTypeEnum.GROUP.getCode());
                    group.setCalSucessFlag(YesNoEnum.yesNoEnum.NO.getValue());
                    StringBuilder stb = new StringBuilder("提示：错误订单，买赠块没有买赠促销！");
                    group.setCalSucessMsg(stb.toString());
                    return orderVo;
                }
                if(promotionCodeSet.size() > 1){
                    orderVo.setCalSucessFlag(YesNoEnum.yesNoEnum.NO.getValue());
                    orderVo.setCalSucessMsgType(OrderEunm.calSucessMsgTypeEnum.GROUP.getCode());
                    group.setCalSucessFlag(YesNoEnum.yesNoEnum.NO.getValue());
                    StringBuilder stb = new StringBuilder("提示：错误订单，买赠块促销多个买赠促销！");
                    group.setCalSucessMsg(stb.toString());
                    return orderVo;
                }
                if(!promotionCodeSet.contains(group.getPromotionCode())){
                    orderVo.setCalSucessFlag(YesNoEnum.yesNoEnum.NO.getValue());
                    orderVo.setCalSucessMsgType(OrderEunm.calSucessMsgTypeEnum.GROUP.getCode());
                    group.setCalSucessFlag(YesNoEnum.yesNoEnum.NO.getValue());
                    StringBuilder stb = new StringBuilder("提示：错误订单，买赠块促销跟买赠块不同！");
                    group.setCalSucessMsg(stb.toString());
                    return orderVo;
                }
            }
        }
        return orderVo;
    }
}
