package com.biz.crm.order.tools.strategy.completionproductmsg.impl;

import com.biz.crm.base.BusinessException;
import com.biz.crm.eunm.YesNoEnum;
import com.biz.crm.eunm.dms.OrderEunm;
import com.biz.crm.mdm.product.MdmProductFeign;
import com.biz.crm.nebular.order.OrderDetailVo;
import com.biz.crm.nebular.order.OrderGroupItemVo;
import com.biz.crm.nebular.order.OrderVo;
import com.biz.crm.nebular.mdm.product.resp.MdmProductAdviseAndPriceReqVo;
import com.biz.crm.nebular.mdm.product.resp.MdmProductAdviseAndPriceRespVo;
import com.biz.crm.order.tools.strategy.completionproductmsg.CompletionProductMsgStrategy;
import com.biz.crm.util.DictUtil;
import com.biz.crm.util.Result;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

import java.util.*;

/**
 * @Description: 免费单补全商品信息
 * @Author: zhangyuzhu
 * @Date: 2021/3/16 17:48
 **/
@ConditionalOnMissingBean(name = "freeCompletionProductMsgStrategyExpand")
@Component("freeCompletionProductMsgStrategy")
public class FreeCompletionProductMsgStrategy implements CompletionProductMsgStrategy {

    @Autowired
    private MdmProductFeign mdmProductFeign;

    @Override
    public OrderVo completion(OrderVo orderVo,String cusCode,String orgCode, Object... objects) {
        List<String> nomalProductCode = this.extractProductCodes(orderVo);
        Result<Map<String, MdmProductAdviseAndPriceRespVo>> result = mdmProductFeign.queryByProductCodeAndCus(
                MdmProductAdviseAndPriceReqVo.newInstanceForSalePrice(cusCode,orgCode,nomalProductCode)
        );
        if(!result.isSuccess()){
            throw new BusinessException("商品服务正在重启，请联系管理员");
        }
        Map<String, MdmProductAdviseAndPriceRespVo> productMsp =result.getResult();
        orderVo = this.packageProductMsgForNormalFree(orderVo,productMsp);
        return orderVo;
    }


    /**
     * 补全产品信息(本品（免费单）)
     * @param orderVo
     * @param productMap
     * @return
     */
    public OrderVo packageProductMsgForNormalFree(OrderVo orderVo, Map<String, MdmProductAdviseAndPriceRespVo> productMap){
        Map<String, String> unitMap = DictUtil.getDictValueMapsByCodes("product_sale_unit");
        for(OrderGroupItemVo groupItemVo : orderVo.getGroupItemVos()){
            this.packageGroupForNormalFree(orderVo,groupItemVo,productMap,unitMap);
        }
        return orderVo;
    }

    /**
     * 补全产品信息(本品)(行)
     * @param orderVo
     * @param groupItemVo
     * @param productMap
     */
    public void packageGroupForNormalFree(OrderVo orderVo,OrderGroupItemVo groupItemVo,Map<String, MdmProductAdviseAndPriceRespVo> productMap
        ,Map<String, String> unitMap){
        if(!CollectionUtils.isEmpty(groupItemVo.getNormalList())){
            List<OrderDetailVo> normalList = new ArrayList<>();
            for(OrderDetailVo item : groupItemVo.getNormalList()){
                MdmProductAdviseAndPriceRespVo product = productMap.get(item.getProductCode());
                if(null == product){
                    orderVo.setCalSucessFlag(YesNoEnum.yesNoEnum.NO.getValue());
                    orderVo.setCalSucessMsgType(OrderEunm.calSucessMsgTypeEnum.LINE.getCode());
                    item.setCalSucessFlag(YesNoEnum.yesNoEnum.NO.getValue());
                    StringBuilder stb = new StringBuilder("提示：商品【")
                            .append(item.getProductName())
                            .append("】已经下架！");
                    item.setCalSucessMsg(stb.toString());
                }else {
                    if(null == product.getSalePrice()){
                        orderVo.setCalSucessFlag(YesNoEnum.yesNoEnum.NO.getValue());
                        orderVo.setCalSucessMsgType(OrderEunm.calSucessMsgTypeEnum.LINE.getCode());
                        item.setCalSucessFlag(YesNoEnum.yesNoEnum.NO.getValue());
                        StringBuilder stb = new StringBuilder("提示：商品【")
                                .append(item.getProductName())
                                .append("】未维护价格，请联系管理员！");
                        item.setCalSucessMsg(stb.toString());
                    }
                    this.packageItemVoForNormalFree(item,product,unitMap);
                }
                normalList.add(item);
            }
            groupItemVo.setNormalList(normalList);
        }
    }

    /**
     * 组装vo信息
     * @param item
     * @param product
     * @return
     */
    public OrderDetailVo packageItemVoForNormalFree(OrderDetailVo item, MdmProductAdviseAndPriceRespVo product,Map<String, String> unitMap){
        item.setProductName(product.getProductName());
        item.setSpec(product.getSpec());
        item.setSalesUnit(product.getSaleUnit());
        item.setSalesUnitName(unitMap.get(product.getSaleUnit()));
        item.setPrice(product.getSalePrice());
        item.setImgUrl(product.getImgUrl());
        item.setProductLevelCode(product.getProductLevelCode());
        return item;
    }


    /**
     * 补全产品信息，提取产品编码
     * @param orderVo
     * @return
     */
    public List<String> extractProductCodes(OrderVo orderVo){
        Set<String> normalSet = new HashSet<>();
        for(OrderGroupItemVo groupItemVo : orderVo.getGroupItemVos()){
            if(!CollectionUtils.isEmpty(groupItemVo.getNormalList())){
                for(OrderDetailVo item : groupItemVo.getNormalList()){
                    normalSet.add(item.getProductCode());
                }
            }
        }
        return new ArrayList<>(normalSet);
    }

}
