package com.biz.crm.mq;

import com.biz.crm.base.BusinessException;
import com.biz.crm.config.SpringApplicationContextUtil;
import com.biz.crm.mq.mqlog.MdmMqMessageLogFeign;
import com.biz.crm.util.JsonPropertyUtil;
import com.biz.crm.util.UserUtils;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.rocketmq.spring.core.RocketMQListener;
import org.springframework.beans.factory.annotation.Autowired;

@Slf4j
public abstract class AbstractRocketMQConsumer implements RocketMQListener<RocketMQMessageBody> {
    @Autowired
    private MdmMqMessageLogFeign mdmMqMessageLogFeign;

    @Override
    public void onMessage(RocketMQMessageBody message) {
        if(null == message){
            log.warn("消费MQ消息：RocketMQMessageBody 为空，忽略本次消费");
            return;
        }
        MdmMqMessageLogVo logVo = new MdmMqMessageLogVo();

        try {
            String beanName = message.getCallbackBeanName();
            MqCallback mqCallback = SpringApplicationContextUtil.getApplicationContext().getBean(beanName, MqCallback.class);
            if(null == mqCallback){
                log.error("消费MQ消息，失败：未能从 Spring 容器内获取到回调实例 >>>> callbackBeanName=" + beanName);
                throw new BusinessException("消费MQ消息，失败：未能从 Spring 容器内获取到回调实例 >>>> callbackBeanName=" + beanName);
            }
            Object result = mqCallback.mqCallback(message.getMsgBody());
            logVo.setCallbackLog(JsonPropertyUtil.toJsonString(result));
        }catch (Exception e){
            log.error("消费MQ消息，失败：message = {} >>>", JsonPropertyUtil.toJsonString(message), e);
            logVo.setCallbackLog(ExceptionUtils.getStackTrace(e));
        }
        if(StringUtils.isBlank(message.getId())){
            log.warn("消费MQ消息，记录日志失败：message = {}", JsonPropertyUtil.toJsonString(message));
            return;
        }
        logVo.setId(message.getId());
        UserUtils.doTokenForNull();
        mdmMqMessageLogFeign.update(logVo);
    }
}
