package com.biz.crm.mq;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotNull;
import java.io.Serializable;

@Data
@ApiModel("MQ消息体")
public class RocketMQMessageBody implements Serializable {
    @ApiModelProperty("id,自动生成，不用传")
    private String id;

    @NotNull
    @ApiModelProperty("队列主题，必传")
    private String topic;

    @ApiModelProperty("自定义消息业务key，选传")
    private String bizKey;

    @ApiModelProperty("消息体，选传")
    private String msgBody;

    /**
     * Bean 实例必须实现
     * @see com.biz.crm.mq.MqCallback 接口
     */
    @ApiModelProperty("回调的bean name，选传")
    private String callbackBeanName;
}
