package com.biz.crm.mq;

import com.alibaba.fastjson.JSON;
import com.biz.crm.base.BusinessException;
import com.biz.crm.mq.mqlog.MdmMqMessageLogFeign;
import com.biz.crm.util.JsonPropertyUtil;
import com.biz.crm.util.Result;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.rocketmq.spring.core.RocketMQTemplate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.messaging.MessagingException;
import org.springframework.stereotype.Component;



/**
 * MQ 发送工具
 *  @author: luoqi
 *  @Date: 2020-9-25 17:35
 *  @version: V1.0
 *  @Description:
 */
@Slf4j
@Component
public class RocketMQProducer {
    @Autowired
    private RocketMQTemplate rocketMQTemplate;
    @Autowired
    private MdmMqMessageLogFeign mdmMqMessageLogFeign;


    /**
     * 发送消息
     *  @author: luoqi
     *  @Date: 2020-9-27 14:50
     *  @version: V1.0
     *  @Description:
     */
    public void send(RocketMQMessageBody mqMessageBody){
        this.check(mqMessageBody);
        MdmMqMessageLogVo logVo = MdmMqMessageLogVo.buildLogVo(mqMessageBody);
        Result<String> result = mdmMqMessageLogFeign.save(logVo);
        if(null != result){
            String logid = result.getResult();
            mqMessageBody.setId(logid);
            logVo.setId(logid);
        }
        try {
            rocketMQTemplate.convertAndSend(mqMessageBody.getTopic(), mqMessageBody);
        }catch (MessagingException e){
            log.error("MQ消息发送失败:mqMessageBody = {} >>>", JsonPropertyUtil.toJsonString(mqMessageBody), e);
            if(StringUtils.isBlank(logVo.getId())){
                log.warn("MQ消息发送成功，记录日志失败：message = {}", JsonPropertyUtil.toJsonString(mqMessageBody));
                return;
            }
            logVo.setSendLog(ExceptionUtils.getStackTrace(e));
            if(StringUtils.isBlank(logVo.getSendLog())){
                logVo.setSendLog("MQ消息发送失败");
            }
            mdmMqMessageLogFeign.update(logVo);
        }


    }

    private void check(RocketMQMessageBody mqMessageBody){
        if(StringUtils.isBlank(mqMessageBody.getTopic())){
            throw new BusinessException("请指定TOPIC");
        }
    }



}
