package com.biz.crm.mq;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;


@Data
@ApiModel(value = "MdmMqMessageLogVo", description = "mq消息日志")
public class MdmMqMessageLogVo  {
    public static final String SUCCESS = "SUCCESS";
    private String id;
    /**
     * topic
     */
    @ApiModelProperty("topicAndTags")
    private String topicAndTags;

    /**
     * 消息业务key,选传
     */
    @ApiModelProperty("消息业务key,选传")
    private String bizKey;

    /**
     * 消息体
     */
    @ApiModelProperty("消息体")
    private String msgBody;

    /**
     * 发送日志
     */
    @ApiModelProperty("发送日志")
    private String sendLog;

    /**
     * 回调日志
     */
    @ApiModelProperty("回调日志")
    private String callbackLog;
    /**
     * 组装日志信息
     *  @author: luoqi
     *  @Date: 2020-9-27 14:50
     *  @version: V1.0
     *  @Description:
     */
    public static MdmMqMessageLogVo buildLogVo(RocketMQMessageBody mqMessageBody){
        MdmMqMessageLogVo logVo = new MdmMqMessageLogVo();
        logVo.setBizKey(mqMessageBody.getBizKey());
//        logVo.setCallbackLog();
//        logVo.setId();
        logVo.setMsgBody(mqMessageBody.getMsgBody());
//        logVo.setSendLog();
        logVo.setTopicAndTags(mqMessageBody.buildTopicTags());
        logVo.setSendLog(MdmMqMessageLogVo.SUCCESS);
        return logVo;
    }

}
