package com.biz.crm.mq;

import com.biz.crm.mq.mqlog.MdmMqMessageLogFeign;
import com.biz.crm.util.JsonPropertyUtil;
import com.biz.crm.util.Result;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.rocketmq.spring.core.RocketMQTemplate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.messaging.MessagingException;
import org.springframework.stereotype.Component;



/**
 * MQ 发送工具
 *  @author: luoqi
 *  @Date: 2020-9-25 17:35
 *  @version: V1.0
 *  @Description:
 */
@Slf4j
@Component
public class RocketMQProducer {
    @Autowired
    private RocketMQTemplate rocketMQTemplate;
    @Autowired
    private MdmMqMessageLogFeign mdmMqMessageLogFeign;
    @Value("${rocketmq.topic}")
    private String topicDef;


    /**
     * 发送消息
     *  @author: luoqi
     *  @Date: 2020-9-27 14:50
     *  @version: V1.0
     *  @Description:
     */
    public void convertAndSend(RocketMQMessageBody mqMessageBody){
        MdmMqMessageLogVo logVo = this.msgLog(mqMessageBody);
        try {
//            MessagePostProcessor messagePostProcessor = new MessagePostProcessor() {
//                @Override
//                public Message<?> postProcessMessage(Message<?> message) {
//                    return null;
//                }
//            };
            rocketMQTemplate.convertAndSend(logVo.getTopicAndTags(), mqMessageBody);
        }catch (MessagingException e){
            this.msgException(logVo, mqMessageBody, e);
        }
    }

    /**
     * 批量
     * @param mqMessageBody
     */
    public void convertAndSendBatch(RocketMQMessageBody mqMessageBody){
        //TODO 批量待实现
        return;
    }


    private void msgException(MdmMqMessageLogVo logVo, RocketMQMessageBody mqMessageBody, MessagingException e){
        log.error("MQ消息发送失败:mqMessageBody = {} >>>", JsonPropertyUtil.toJsonString(mqMessageBody), e);
        if(StringUtils.isBlank(logVo.getId())){
            log.warn("MQ消息发送成功，记录日志失败：message = {}", JsonPropertyUtil.toJsonString(mqMessageBody));
            return;
        }
        logVo.setSendLog(ExceptionUtils.getStackTrace(e));
        if(StringUtils.isBlank(logVo.getSendLog())){
            logVo.setSendLog("MQ消息发送失败");
        }
        mdmMqMessageLogFeign.update(logVo);
    }

    private MdmMqMessageLogVo msgLog(RocketMQMessageBody mqMessageBody){
        if(StringUtils.isBlank(mqMessageBody.getTopic())){
            mqMessageBody.setTopic(this.topicDef);
        }
        MdmMqMessageLogVo logVo = MdmMqMessageLogVo.buildLogVo(mqMessageBody);
        Result<String> result = mdmMqMessageLogFeign.save(logVo);
        if(null != result){
            String logid = result.getResult();
            mqMessageBody.setId(logid);
            logVo.setId(logid);
        }
        return logVo;
    }




}
