package com.biz.crm.mq;

import com.biz.crm.base.BusinessException;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.apache.commons.lang3.StringUtils;
import org.springframework.util.CollectionUtils;

import javax.validation.constraints.NotNull;
import java.io.Serializable;
import java.util.List;
import java.util.stream.Collectors;

@Data
@ApiModel("MQ消息体")
public class RocketMQMessageBody implements Serializable {
    @ApiModelProperty("id,自动生成，不用传")
    private String id;

    /**
     * TOPIC 主题，系统会默认使用 rocketmq.topic + rocketmq.environment-variable，不建议传入自定义TOPIC
     */
    @NotNull
    @ApiModelProperty("TOPIC 主题，系统会默认使用 rocketmq.topic + rocketmq.environment-variable，不建议传入自定义TOPIC")
    private String topic;

    /**
     * 消息标签列表,必传。Consumer 根据标签消费消息
     * 一个消息只能有一个标签
     */
    @NotNull
    @ApiModelProperty("消息标签列表,必传。Consumer 根据标签消费消息, 一个消息只能有一个标签")
    private String tag;


    @ApiModelProperty("消息体，选传")
    private String msgBody;


    @ApiModelProperty("该消息自定义业务标识，选传。")
    private String bizKey;


    /**
     * 组装 topic 和 tags
     *  @author: luoqi
     *  @Date: 2020-10-30 10:51
     *  @version: V1.0
     *  @Description:
     */
    public String buildTopicTags(){
        if(StringUtils.isBlank(this.topic)){
            throw new BusinessException("请指定MQ消息TOPIC");
        }
        if(StringUtils.isBlank(this.tag)){
            throw new BusinessException("请指定MQ消息TAGS");
        }
        return this.topic + ":" + this.tag;
    }
}
