/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.mq;

import com.biz.crm.base.BusinessException;
import com.biz.crm.mq.MdmMqMessageLogVo;
import com.biz.crm.mq.RocketMQMessageBody;
import com.biz.crm.mq.mqlog.MdmMqMessageLogFeign;
import com.biz.crm.util.CrmDateUtils;
import com.biz.crm.util.JsonPropertyUtil;
import com.biz.crm.util.UserUtils;
import java.time.LocalDateTime;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.rocketmq.spring.core.RocketMQListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public abstract class AbstractRocketMQConsumer
implements RocketMQListener<RocketMQMessageBody> {
    private static final Logger log = LoggerFactory.getLogger(AbstractRocketMQConsumer.class);
    @Autowired
    private MdmMqMessageLogFeign mdmMqMessageLogFeign;

    public void onMessage(RocketMQMessageBody message) {
        if (null == message) {
            log.warn("\u6d88\u8d39MQ\u6d88\u606f\uff1aRocketMQMessageBody \u4e3a\u7a7a\uff0c\u5ffd\u7565\u672c\u6b21\u6d88\u8d39");
            throw new BusinessException("\u6d88\u8d39MQ\u6d88\u606f\uff1aRocketMQMessageBody \u4e3a\u7a7a\uff0c\u5ffd\u7565\u672c\u6b21\u6d88\u8d39");
        }
        MdmMqMessageLogVo logVo = new MdmMqMessageLogVo();
        Exception handleException = null;
        String json = JsonPropertyUtil.toJsonString((Object)message);
        try {
            UserUtils.doTokenForNull();
            logVo.setCallbackBegin(LocalDateTime.now().format(CrmDateUtils.yyyyMMddHHmmssSSS));
            Object result = this.handleMessage(message);
            logVo.setCallbackEnd(LocalDateTime.now().format(CrmDateUtils.yyyyMMddHHmmssSSS));
            logVo.setCallbackLog(JsonPropertyUtil.toJsonString((Object)result));
        }
        catch (Exception e) {
            log.error("\u6d88\u8d39MQ\u6d88\u606f\uff0c\u5931\u8d25\uff1amessage = {} >>>", (Object)json, (Object)e);
            logVo.setCallbackLog(ExceptionUtils.getStackTrace((Throwable)e));
            handleException = e;
        }
        if (StringUtils.isBlank((CharSequence)message.getId())) {
            log.warn("\u6d88\u8d39MQ\u6d88\u606f\uff0c\u8bb0\u5f55\u65e5\u5fd7\u5931\u8d25\uff1amessage = {}", (Object)json);
            if (null != handleException) {
                throw new BusinessException("\u6d88\u8d39MQ\u6d88\u606f\uff0c\u5931\u8d25\uff1amessage = " + json, (Throwable)handleException);
            }
            return;
        }
        try {
            logVo.setId(message.getId());
            UserUtils.doTokenForNull();
            this.mdmMqMessageLogFeign.update(logVo);
        }
        catch (Exception e) {
            log.error("\u6d88\u8d39MQ\u6d88\u606f\uff0c\u8bb0\u5f55\u65e5\u5fd7\u5931\u8d25\uff1amessage = {} >>>", (Object)json, (Object)e);
        }
        if (null != handleException) {
            throw new BusinessException("\u6d88\u8d39MQ\u6d88\u606f\uff0c\u5931\u8d25\uff1amessage = " + json, (Throwable)handleException);
        }
    }

    protected abstract Object handleMessage(RocketMQMessageBody var1) throws InterruptedException;
}

