package com.biz.crm.mq;

import com.biz.crm.eunm.CrmEnableStatusEnum;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;


@Data
@ApiModel(value = "MdmMqMessageLogVo", description = "mq消息日志")
public class MdmMqMessageLogVo  implements java.io.Serializable{
    private static final long serialVersionUID = 1L;
    private String id;
    @ApiModelProperty("topic")
    private String topicAndTags;


    @ApiModelProperty("消息业务key,选传")
    private String bizKey;

    /**
     * 消息体
     */
    @ApiModelProperty("消息体")
    private String msgBody;

    /**
     * 发送日志
     */
    @ApiModelProperty("发送日志")
    private String sendLog;

    /**
     * 回调日志
     */
    @ApiModelProperty("回调日志")
    private String callbackLog;
    /**
     * 回调开始
     */
    @ApiModelProperty("回调开始")
    private String callbackBegin;
    /**
     * 回调结束
     */
    @ApiModelProperty("回调结束")
    private String callbackEnd;
    //发送状态 009 成功 003 失败
    @ApiModelProperty("发送状态 009 成功 003 失败")
    private String sendStatus;
    //接收状态 009 成功 003 失败
    @ApiModelProperty("接收状态 009 成功 003 失败")
    private String endStatus;
    @ApiModelProperty("最近一次接收时间")
    private String updateDateAll;
    @ApiModelProperty("发送时间")
    private String createDateAll;
    @ApiModelProperty("创建日期")
    private String createDate;
    @ApiModelProperty("修改日期")
    private String updateDate;
    @ApiModelProperty("消息id")
    private String msgId;
    public static MdmMqMessageLogVo buildLogVo(RocketMQMessageBody mqMessageBody){
        MdmMqMessageLogVo logVo = new MdmMqMessageLogVo();
        logVo.setBizKey(mqMessageBody.getBizKey());
        logVo.setMsgBody(mqMessageBody.getMsgBody());
        logVo.setTopicAndTags(mqMessageBody.buildTopicTags());
        logVo.setSendStatus(CrmEnableStatusEnum.ENABLE.getCode());
        return logVo;
    }

}
