/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.mq;

import com.alibaba.fastjson.JSON;
import com.biz.crm.base.BusinessException;
import com.biz.crm.eunm.CrmEnableStatusEnum;
import com.biz.crm.mq.MdmMqMessageLogVo;
import com.biz.crm.mq.RocketMQMessageBody;
import com.biz.crm.mq.mqlog.MdmMqMessageLogFeign;
import com.biz.crm.service.RedisService;
import com.biz.crm.util.JsonPropertyUtil;
import com.biz.crm.util.Result;
import com.biz.crm.util.UserUtils;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.rocketmq.client.producer.SendResult;
import org.apache.rocketmq.spring.core.RocketMQTemplate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.messaging.MessagingException;
import org.springframework.stereotype.Component;

@Component
public class RocketMQProducer {
    private static final Logger log = LoggerFactory.getLogger(RocketMQProducer.class);
    @Autowired
    private RocketMQTemplate rocketMQTemplate;
    @Autowired
    private MdmMqMessageLogFeign mdmMqMessageLogFeign;
    @Autowired
    private RedisService redisService;
    @Value(value="${rocketmq.topic}${rocketmq.environment-variable}")
    private String topicDef;

    public void convertAndSend(RocketMQMessageBody mqMessageBody) {
        MdmMqMessageLogVo logVo = this.msgLog(mqMessageBody);
        log.info("MQ\u6d88\u606f\u53d1\u9001\u6d88\u606f[mqMessageBody]\uff1a" + JSON.toJSONString((Object)mqMessageBody));
        try {
            HashMap header = Maps.newHashMap();
            header.put("KEYS", logVo.getId());
            mqMessageBody.setToken(UserUtils.getToken());
            this.rocketMQTemplate.convertAndSend((Object)logVo.getTopicAndTags(), (Object)mqMessageBody, (Map)header);
        }
        catch (MessagingException e) {
            this.msgException(logVo, mqMessageBody, (Exception)((Object)e));
            throw new BusinessException("MQ\u6d88\u606f\u53d1\u9001\u5931\u8d25");
        }
    }

    public void convertAndSendBatch(RocketMQMessageBody mqMessageBody) {
    }

    public void syncSendOrderly(RocketMQMessageBody mqMessageBody) {
        MdmMqMessageLogVo logVo = this.msgLog(mqMessageBody);
        try {
            HashMap header = Maps.newHashMap();
            header.put("KEYS", logVo.getId());
            SendResult sendResult = this.rocketMQTemplate.syncSendOrderly(logVo.getTopicAndTags(), (Object)mqMessageBody, mqMessageBody.getTag());
        }
        catch (Exception e) {
            log.error("MQ\u6d88\u606f\u53d1\u9001\u5931\u8d25", (Throwable)e);
            this.msgException(logVo, mqMessageBody, e);
            throw new BusinessException("MQ\u6d88\u606f\u53d1\u9001\u5931\u8d25");
        }
    }

    private void msgException(MdmMqMessageLogVo logVo, RocketMQMessageBody mqMessageBody, Exception e) {
        log.error("MQ\u6d88\u606f\u53d1\u9001\u5931\u8d25:mqMessageBody = {} >>>", (Object)JsonPropertyUtil.toJsonString((Object)mqMessageBody), (Object)e);
        logVo.setSendLog(ExceptionUtils.getStackTrace((Throwable)e));
        if (StringUtils.isBlank((CharSequence)logVo.getSendLog())) {
            logVo.setSendLog("MQ\u6d88\u606f\u53d1\u9001\u5931\u8d25");
        }
        logVo.setSendStatus(CrmEnableStatusEnum.DISABLE.getCode());
        this.redisService.setDays("MQ_MESSAGE:" + logVo.getId(), (Object)logVo, 5L);
        this.mdmMqMessageLogFeign.updateById(logVo.getId());
    }

    private MdmMqMessageLogVo msgLog(RocketMQMessageBody mqMessageBody) {
        String logid;
        MdmMqMessageLogVo logVo;
        Result<String> result;
        if (StringUtils.isBlank((CharSequence)mqMessageBody.getTopic())) {
            mqMessageBody.setTopic(this.topicDef);
        }
        if (null != (result = this.mdmMqMessageLogFeign.save(logVo = MdmMqMessageLogVo.buildLogVo(mqMessageBody)))) {
            logid = (String)result.getResult();
            if (StringUtils.isBlank((CharSequence)logid)) {
                log.warn("\u8bb0\u5f55\u65e5\u5fd7\u5931\u8d25\uff1amqMessageBody = {}", (Object)JsonPropertyUtil.toJsonString((Object)mqMessageBody));
                throw new BusinessException(result.getMessage() + "MDM-MQ\u65e5\u5fd7\u670d\u52a1\u4e0d\u53ef\u7528\uff0c\u8bf7\u91cd\u8bd5\uff01");
            }
        } else {
            log.warn("\u8bb0\u5f55\u65e5\u5fd7\u5931\u8d25\uff1amqMessageBody = {}", (Object)JsonPropertyUtil.toJsonString((Object)mqMessageBody));
            throw new BusinessException("MDM-MQ\u65e5\u5fd7\u670d\u52a1\u4e0d\u53ef\u7528\uff0c\u8bf7\u91cd\u8bd5\uff01");
        }
        mqMessageBody.setId(logid);
        logVo.setId(logid);
        this.redisService.setDays("MQ_MESSAGE:" + logVo.getId(), (Object)logVo, 5L);
        return logVo;
    }
}

