/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.mq;

import com.biz.crm.base.BusinessException;
import com.biz.crm.eunm.CrmEnableStatusEnum;
import com.biz.crm.mq.RocketMQMessageBody;
import com.biz.crm.mq.mqlog.MdmMqMessageLogEs;
import com.biz.crm.mq.mqlog.MdmMqMessageLogRepository;
import com.biz.crm.service.RedisService;
import com.biz.crm.util.CrmBeanUtil;
import com.biz.crm.util.CrmDateUtils;
import com.biz.crm.util.DateUtil;
import com.biz.crm.util.JsonPropertyUtil;
import com.biz.crm.util.UserUtils;
import java.time.LocalDateTime;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.rocketmq.spring.core.RocketMQListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractRocketMQConsumer
implements RocketMQListener<RocketMQMessageBody> {
    private static final Logger log = LoggerFactory.getLogger(AbstractRocketMQConsumer.class);
    @Resource
    private MdmMqMessageLogRepository mdmMqMessageLogRepository;
    @Resource
    private RedisService redisService;

    public void onMessage(RocketMQMessageBody message) {
        String token = message.getToken();
        if (StringUtils.isBlank((CharSequence)token)) {
            UserUtils.doTokenForNull();
        } else {
            UserUtils.setToken((String)token);
        }
        if (null == message) {
            log.warn("\u6d88\u8d39MQ\u6d88\u606f\uff1aRocketMQMessageBody \u4e3a\u7a7a\uff0c\u5ffd\u7565\u672c\u6b21\u6d88\u8d39");
            throw new BusinessException("\u6d88\u8d39MQ\u6d88\u606f\uff1aRocketMQMessageBody \u4e3a\u7a7a\uff0c\u5ffd\u7565\u672c\u6b21\u6d88\u8d39");
        }
        Exception handleException = null;
        String json = JsonPropertyUtil.toJsonString((Object)message);
        if (StringUtils.isBlank((CharSequence)message.getId())) {
            log.warn("\u6d88\u8d39MQ\u6d88\u606f\uff0c\u8bb0\u5f55\u65e5\u5fd7\u5931\u8d25\uff1amessage = {}", (Object)json);
            if (null != handleException) {
                throw new BusinessException("\u6d88\u8d39MQ\u6d88\u606f\uff0c\u5931\u8d25\uff1amessage = " + json, handleException);
            }
            return;
        }
        Object o = this.redisService.get("MQ_MESSAGE:" + message.getId());
        MdmMqMessageLogEs logVo = new MdmMqMessageLogEs();
        if (o != null) {
            logVo = o instanceof MdmMqMessageLogEs ? (MdmMqMessageLogEs)o : (MdmMqMessageLogEs)CrmBeanUtil.copy((Object)o, MdmMqMessageLogEs.class);
        }
        logVo.setUpdateDate(DateUtil.formatDate());
        logVo.setUpdateDateSecond(DateUtil.dateNowStrHms());
        try {
            logVo.setCallbackBegin(LocalDateTime.now().format(CrmDateUtils.yyyyMMddHHmmssSSS));
            Object result = this.handleMessage(message);
            logVo.setCallbackEnd(LocalDateTime.now().format(CrmDateUtils.yyyyMMddHHmmssSSS));
            logVo.setCallbackLog(JsonPropertyUtil.toJsonString((Object)result));
            logVo.setEndStatus(CrmEnableStatusEnum.ENABLE.getCode());
        }
        catch (Exception e) {
            log.error("\u6d88\u8d39MQ\u6d88\u606f\uff0c\u5931\u8d25\uff1amessage = {} >>>", (Object)json, (Object)e);
            logVo.setCallbackLog(ExceptionUtils.getStackTrace((Throwable)e));
            logVo.setEndStatus(CrmEnableStatusEnum.DISABLE.getCode());
            handleException = e;
        }
        try {
            logVo.setId(message.getId());
            this.redisService.setDays("MQ_MESSAGE:" + logVo.getId(), (Object)logVo, 5L);
            this.mdmMqMessageLogRepository.save(logVo);
        }
        catch (Exception e) {
            log.error("\u6d88\u8d39MQ\u6d88\u606f\uff0c\u8bb0\u5f55\u65e5\u5fd7\u5931\u8d25\uff1amessage = {} >>>", (Object)json, (Object)e);
        }
        if (null != handleException) {
            throw new BusinessException("\u6d88\u8d39MQ\u6d88\u606f\uff0c\u5931\u8d25\uff1amessage = " + json, (Throwable)handleException);
        }
    }

    protected abstract Object handleMessage(RocketMQMessageBody var1) throws InterruptedException;
}

