/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.mq;

import com.biz.crm.base.BusinessException;
import com.biz.crm.mq.RocketMQMessageBody;
import com.biz.crm.mq.mqlog.MdmMqMessageLogRepository;
import com.biz.crm.service.RedisService;
import com.biz.crm.util.JsonPropertyUtil;
import com.biz.crm.util.UserUtils;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.apache.rocketmq.spring.core.RocketMQListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractRocketMQConsumer
implements RocketMQListener<RocketMQMessageBody> {
    private static final Logger log = LoggerFactory.getLogger(AbstractRocketMQConsumer.class);
    @Resource
    private MdmMqMessageLogRepository mdmMqMessageLogRepository;
    @Resource
    private RedisService redisService;

    public void onMessage(RocketMQMessageBody message) {
        String token = message.getToken();
        if (StringUtils.isBlank((CharSequence)token)) {
            UserUtils.doTokenForNull();
        } else {
            UserUtils.setToken((String)token);
        }
        if (null == message) {
            log.warn("\u6d88\u8d39MQ\u6d88\u606f\uff1aRocketMQMessageBody \u4e3a\u7a7a\uff0c\u5ffd\u7565\u672c\u6b21\u6d88\u8d39");
            throw new BusinessException("\u6d88\u8d39MQ\u6d88\u606f\uff1aRocketMQMessageBody \u4e3a\u7a7a\uff0c\u5ffd\u7565\u672c\u6b21\u6d88\u8d39");
        }
        String json = JsonPropertyUtil.toJsonString((Object)message);
        try {
            Object object = this.handleMessage(message);
        }
        catch (Exception e) {
            log.error("\u6d88\u8d39MQ\u6d88\u606f\uff0c\u5931\u8d25\uff1amessage = {} >>>", (Object)json, (Object)e);
        }
    }

    protected abstract Object handleMessage(RocketMQMessageBody var1) throws InterruptedException;
}

