/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.mq;

import com.alibaba.fastjson.JSON;
import com.biz.crm.base.BusinessException;
import com.biz.crm.eunm.CrmEnableStatusEnum;
import com.biz.crm.mq.RocketMQMessageBody;
import com.biz.crm.mq.mqlog.MdmMqMessageLogEs;
import com.biz.crm.service.RedisService;
import com.biz.crm.util.JsonPropertyUtil;
import com.biz.crm.util.UserUtils;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.rocketmq.client.producer.SendResult;
import org.apache.rocketmq.spring.core.RocketMQTemplate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.messaging.MessagingException;
import org.springframework.stereotype.Component;

@Component
public class RocketMQProducer {
    private static final Logger log = LoggerFactory.getLogger(RocketMQProducer.class);
    @Resource
    private RocketMQTemplate rocketMQTemplate;
    @Resource
    private RedisService redisService;
    @Value(value="${rocketmq.topic}${rocketmq.environment-variable}")
    private String topicDef;

    public void convertAndSend(RocketMQMessageBody mqMessageBody) {
        MdmMqMessageLogEs logVo = this.msgLog(mqMessageBody);
        log.info("MQ\u6d88\u606f\u53d1\u9001\u6d88\u606f[mqMessageBody]\uff1a" + JSON.toJSONString((Object)mqMessageBody));
        try {
            HashMap header = Maps.newHashMap();
            header.put("KEYS", logVo.getId());
            this.rocketMQTemplate.convertAndSend((Object)logVo.getTopicAndTags(), (Object)mqMessageBody, (Map)header);
        }
        catch (MessagingException e) {
            this.msgException(logVo, mqMessageBody, (Exception)((Object)e));
            throw new BusinessException("MQ\u6d88\u606f\u53d1\u9001\u5931\u8d25");
        }
    }

    public void convertAndSendBatch(RocketMQMessageBody mqMessageBody) {
    }

    public void syncSendOrderly(RocketMQMessageBody mqMessageBody) {
        MdmMqMessageLogEs logVo = this.msgLog(mqMessageBody);
        try {
            HashMap header = Maps.newHashMap();
            header.put("KEYS", logVo.getId());
            SendResult sendResult = this.rocketMQTemplate.syncSendOrderly(logVo.getTopicAndTags(), (Object)mqMessageBody, mqMessageBody.getTag());
        }
        catch (Exception e) {
            log.error("MQ\u6d88\u606f\u53d1\u9001\u5931\u8d25", (Throwable)e);
            this.msgException(logVo, mqMessageBody, e);
            throw new BusinessException("MQ\u6d88\u606f\u53d1\u9001\u5931\u8d25");
        }
    }

    private void msgException(MdmMqMessageLogEs logVo, RocketMQMessageBody mqMessageBody, Exception e) {
        log.error("MQ\u6d88\u606f\u53d1\u9001\u5931\u8d25:mqMessageBody = {} >>>", (Object)JsonPropertyUtil.toJsonString((Object)mqMessageBody), (Object)e);
        logVo.setSendLog(ExceptionUtils.getStackTrace((Throwable)e));
        if (StringUtils.isBlank((CharSequence)logVo.getSendLog())) {
            logVo.setSendLog("MQ\u6d88\u606f\u53d1\u9001\u5931\u8d25");
        }
        logVo.setSendStatus(CrmEnableStatusEnum.DISABLE.getCode());
        this.redisService.setDays("MQ_MESSAGE:" + logVo.getId(), (Object)logVo, 5L);
    }

    private MdmMqMessageLogEs msgLog(RocketMQMessageBody mqMessageBody) {
        if (StringUtils.isBlank((CharSequence)mqMessageBody.getTopic())) {
            mqMessageBody.setTopic(this.topicDef);
        }
        if (StringUtils.isBlank((CharSequence)mqMessageBody.getToken())) {
            mqMessageBody.setToken(UserUtils.getToken());
        }
        MdmMqMessageLogEs logVo = MdmMqMessageLogEs.buildLogVo(mqMessageBody);
        mqMessageBody.setId(logVo.getId());
        this.redisService.setDays("MQ_MESSAGE:" + logVo.getId(), (Object)logVo, 5L);
        return logVo;
    }
}

