package com.biz.crm.mq.mqlog;

import com.biz.crm.eunm.CrmEnableStatusEnum;
import com.biz.crm.mq.RocketMQMessageBody;
import com.biz.crm.util.DateUtil;
import com.biz.crm.util.StringUtils;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.springframework.data.annotation.Id;
import org.springframework.data.elasticsearch.annotations.Document;
import org.springframework.data.elasticsearch.annotations.Field;
import org.springframework.data.elasticsearch.annotations.FieldType;

/**
 * @author jianglong
 * @version V1.0
 * @Package com.biz.crm.mqlog.model
 * @Description: TODO
 * @date 2021/3/12 上午10:18
 */
@Data
@Document(indexName = "index_mdmmqmessageloges",refreshInterval = "300s")
public class MdmMqMessageLogEs implements java.io.Serializable {
    @Id
    private String id;

    @Field(type = FieldType.Text)
    @ApiModelProperty("topic")
    private String topicAndTags;


    @Field(type = FieldType.Text)
    @ApiModelProperty("消息业务key,选传")
    private String bizKey;

    /**
     * 消息体
     */
    @Field(type = FieldType.Text)
    @ApiModelProperty("消息体")
    private String msgBody;

    /**
     * 发送日志
     */
    @Field(type = FieldType.Text)
    @ApiModelProperty("发送日志")
    private String sendLog;

    /**
     * 回调日志
     */
    @Field(type = FieldType.Text)
    @ApiModelProperty("回调日志")
    private String callbackLog;
    /**
     * 回调开始
     */
    @Field(type = FieldType.Text)
    @ApiModelProperty("回调开始")
    private String callbackBegin;
    /**
     * 回调结束
     */
    @Field(type = FieldType.Text)
    @ApiModelProperty("回调结束")
    private String callbackEnd;
    //发送状态 009 成功 003 失败
    @Field(type = FieldType.Text)
    @ApiModelProperty("发送状态 009 成功 003 失败")
    private String sendStatus;
    //接收状态 009 成功 003 失败
    @Field(type = FieldType.Text)
    @ApiModelProperty("接收状态 009 成功 003 失败")
    private String endStatus;
    @Field(type = FieldType.Text)
    @ApiModelProperty("最近一次接收时间")
    private String updateDateAll;
    @Field(type = FieldType.Text)
    @ApiModelProperty("发送时间")
    private String createDateAll;
    @Field(type = FieldType.Text)
    @ApiModelProperty("创建日期")
    private String createDate;
    @Field(type = FieldType.Text)
    @ApiModelProperty("创建 时分秒")
    private String createDateSecond;
    @ApiModelProperty("修改")
    @Field(type = FieldType.Text)
    private String updateDateSecond;
    @ApiModelProperty("修改日期")
    @Field(type = FieldType.Text)
    private String updateDate;
    @Field(type = FieldType.Text)
    @ApiModelProperty("消息id")
    private String msgId;
    public String getUpdateDateAll() {
        return (StringUtils.isNotEmpty(updateDate) ? updateDate + " " : "") + (StringUtils.isNotEmpty(updateDateSecond) ? updateDateSecond : "");
    }

    public String getCreateDateAll() {
        return (StringUtils.isNotEmpty(createDate) ? createDate + " " : "") + (StringUtils.isNotEmpty(createDateSecond) ? createDateSecond : "");
    }

    public static MdmMqMessageLogEs buildLogVo(RocketMQMessageBody mqMessageBody){
        MdmMqMessageLogEs logVo = new MdmMqMessageLogEs();
        logVo.setBizKey(mqMessageBody.getBizKey());
        logVo.setMsgBody(mqMessageBody.getMsgBody());
        logVo.setTopicAndTags(mqMessageBody.buildTopicTags());
        logVo.setSendStatus(CrmEnableStatusEnum.ENABLE.getCode());
        logVo.setCreateDate(DateUtil.formatDate());
        logVo.setCreateDateSecond(DateUtil.dateNowStrHms());
        return logVo;
    }
}
