package com.biz.crm.rule.utils;

import groovy.lang.GroovyShell;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cglib.beans.BeanMap;
import org.springframework.util.StringUtils;

import java.util.HashMap;
import java.util.Map;


/**
 * GroovyShell 脚本执行工具
 *  @author: luoqi
 *  @Date: 2020-10-14 18:21
 *  @version: V1.0
 *  @Description:
 */
public class GroovyShellUtil {
    private static final int MAX_CLASS_CACHE = 150;
    private static final Logger log = LoggerFactory.getLogger(GroovyShellUtil.class);

//    public static void ddd(){
//        GroovyShell groovyShell = build(null);
//GroovyShell groovyShell = new GroovyShell();
//        groovyShell.parse("", "");
//        groovyShell.getClassLoader().clearCache();
//        def bindings = new Binding()
//        bindings.setVariable("somename", "mrhaki")
//        def shell = new GroovyShell(bindings)
//        shell.parse(new File('external.groovy'))
//        shell.run()
//    }


    private static Map<String, Object> buildParam(BaseGroovyShellParam param){
        Map<String, Object> paramsMap ;
        if(null == param.getTestParamMap()){
            paramsMap = new HashMap<>();
        }else{
            paramsMap = param.getTestParamMap();
        }
        BeanMap beanMap = BeanMap.create(param);
        for (Object key : beanMap.keySet()) {
            if(BaseGroovyShellParam.TEST_PARAM_MAP.equals(key)){
                continue;
            }
            paramsMap.put(key.toString(), beanMap.get(key));
        }
        return paramsMap;
    }
    /**
     * shell 脚本体 必传
     * shellparam 脚本参数 必传
     *  @author: luoqi
     *  @Date: 2020-10-14 18:39
     *  @version: V1.0
     *  @Description:
     */
    public static <Param extends BaseGroovyShellParam> ShellResult runShell(String shell, Param shellparam){
        ShellResult result = check(shell, shellparam);
        if(!result.getState()){
            return result;
        }
        Map<String, Object> paramsMap = buildParam(shellparam);
//        paramsMap.put("paramAsCustomer", params);
        String shellName = shellparam.getShellName();
        try{
            GroovyShell groovyShell = buildGroovyShell(paramsMap);
            Object o = groovyShell.evaluate(shell, shellName);
            result.setResultData(o);
            //清理缓存
//            if(shellparam.getClearCache() || groovyShell.getClassLoader().getLoadedClasses().length > MAX_CLASS_CACHE){
//            }
            groovyShell.getClassLoader().clearCache();
        }catch (Exception e){
            result.setErrMsg("脚本[" + shellName + "]执行错误，请检查脚本体和脚本参数");
            result.setThrowable(e);
            result.setState(false);
            log.warn("脚本[" + shellName + "]执行错误，请检查脚本体 >>> shell={}, shellName={}",shell , shellName, e);
        }
        return result;
    }

    /**
     *
     * @param params
     * @return
     */
    private static GroovyShell buildGroovyShell(Map<String, Object> params){
        GroovyShell groovyShell = new GroovyShell();
        if(null != params){
            for(Map.Entry<String, Object> entry : params.entrySet()){
                groovyShell.setVariable(entry.getKey(), entry.getValue());
            }
        }
        return groovyShell;
    }

    /**
     *
     * @param shell
     * @param param
     * @return
     */
    private static ShellResult check(String shell, BaseGroovyShellParam param){
        ShellResult result = new ShellResult();
        String shellName = param.getShellName();
        if(StringUtils.isEmpty(shell) || StringUtils.isEmpty(shellName)){
            result.setErrMsg("已中断脚本执行，请指定脚本体或脚本编码");
            result.setState(false);
            log.warn("已中断脚本执行，请指定脚本体或脚本编码 >>> shell={}, shellName={}",shell , shellName);
            return result;
        }
        return result;
    }
}
