package com.biz.crm.achievement.controller;

import com.biz.crm.achievement.service.ISfaAchievementAccomplishRecordService;
import com.biz.crm.mq.AbstractRocketMQConsumer;
import com.biz.crm.mq.RocketMQConstant;
import com.biz.crm.mq.RocketMQMessageBody;
import com.biz.crm.nebular.sfa.achievement.req.SfaAchievementAccomplishRecordReqVo;
import com.biz.crm.util.JsonPropertyUtil;
import lombok.extern.slf4j.Slf4j;
import org.apache.rocketmq.spring.annotation.RocketMQMessageListener;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

import javax.annotation.Resource;
import java.util.List;

/**
 * @author yangshan
 * @date 2021/3/26 18:33
 */
@Slf4j
@Component
@RocketMQMessageListener(topic = "${rocketmq.topic}" + "${rocketmq.environment-variable}",
        /**
         * tag
         * 可用 || 监听多个tag： "tag1 || tag2 || tag3"
         * 请把tag定义在 RocketMQConstant.CRM_MQ_TAG 内统一维护
        */
        selectorExpression = RocketMQConstant.CRM_MQ_TAG.INDEX_ACCOMPLISH_RECORDS_TAG,
        /**
         * 相同分组下 consumer 可自动负载均衡
         * 请把consumerGroup定义在 RocketMQConstant.CONSUMER_GROUP 内统一维护
        */
        consumerGroup = RocketMQConstant.CONSUMER_GROUP.INDEX_ACCOMPLISH_RECORDS + "${rocketmq.environment-variable}")
public class AchievementRecordsRocketMQConsumer extends AbstractRocketMQConsumer {

    @Resource
    private ISfaAchievementAccomplishRecordService sfaAchievementAccomplishRecordService;

    @Override
    protected Object handleMessage(RocketMQMessageBody message) throws InterruptedException {
        String msg = message.getMsgBody();
        if(StringUtils.isEmpty(msg)){
            return "消息为空!";
        }
        SfaAchievementAccomplishRecordReqVo reqVo = JsonPropertyUtil.toObject(msg, SfaAchievementAccomplishRecordReqVo.class);
        if(StringUtils.isEmpty(reqVo)){
            return "记录为空!";
        }
        sfaAchievementAccomplishRecordService.save(reqVo);
        return "操作成功";
    }
}
