package com.biz.crm.achievement.controller;

import com.biz.crm.base.ApiResultUtil;
import com.biz.crm.mdm.customer.MdmCustomerMsgFeign;
import com.biz.crm.mdm.terminal.MdmTerminalFeign;
import com.biz.crm.moblie.service.SfaCustomerService;
import com.biz.crm.moblie.service.SfaTerminalService;
import com.biz.crm.mq.AbstractRocketMQConsumer;
import com.biz.crm.mq.RocketMQConstant;
import com.biz.crm.mq.RocketMQMessageBody;
import com.biz.crm.nebular.mdm.customer.MdmCustomerMsgRespVo;
import com.biz.crm.nebular.mdm.terminal.MdmTerminalVo;
import com.biz.crm.util.CollectionUtil;
import com.biz.crm.util.JsonPropertyUtil;
import lombok.extern.slf4j.Slf4j;
import org.apache.rocketmq.spring.annotation.RocketMQMessageListener;
import org.springframework.stereotype.Component;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

import javax.annotation.Resource;
import java.util.List;

/**
 * @author yangshan
 * 新增客户或经销商完成后，发送mq计算绩效或积分
 */
@Slf4j
@Component
@RocketMQMessageListener(topic = "${rocketmq.topic}" + "${rocketmq.environment-variable}",
        /**
         * tag
         * 可用 || 监听多个tag： "tag1 || tag2 || tag3"
         * 请把tag定义在 RocketMQConstant.CRM_MQ_TAG 内统一维护
        */
        selectorExpression = RocketMQConstant.CRM_MQ_TAG.INSERT_CLIENT_TAG,
        /**
         * 相同分组下 consumer 可自动负载均衡
         * 请把consumerGroup定义在 RocketMQConstant.CONSUMER_GROUP 内统一维护
        */
        consumerGroup = RocketMQConstant.CONSUMER_GROUP.INSERT_CLIENT + "${rocketmq.environment-variable}")
public class AchievementRocketMQConsumer extends AbstractRocketMQConsumer {

    @Resource
    protected SfaCustomerService sfaCustomerService;
    @Resource
    protected SfaTerminalService sfaTerminalService;
    @Resource
    protected MdmTerminalFeign mdmTerminalFeign;
    @Resource
    protected MdmCustomerMsgFeign mdmCustomerMsgFeign;

    @Override
    protected Object handleMessage(RocketMQMessageBody message) throws InterruptedException {
        String msg = message.getMsgBody();
        if(StringUtils.isEmpty(msg)){
            return "消息为空!";
        }
        List<String> list = JsonPropertyUtil.toArray(msg, String.class);
        if(StringUtils.isEmpty(list)){
            return "记录为空!";
        }
        this.queryTerminalOrCustomer(list);
        return "操作成功";
    }

    /**
     * 根据code获取新增终端或经销商信息
     * @param list
     */
    protected void queryTerminalOrCustomer(List<String> list){
        if (CollectionUtil.listEmpty(list)){
            log.info("计算失败，终端或经销商编码为空");
            return;
        }
        MdmTerminalVo mdmTerminalVo = ApiResultUtil.objResult(mdmTerminalFeign.query(null, list.get(0)));
        MdmCustomerMsgRespVo mdmCustomerMsgRespVo = ApiResultUtil.objResult(mdmCustomerMsgFeign.query(null, list.get(0)));
        if (ObjectUtils.isEmpty(mdmCustomerMsgRespVo) && ObjectUtils.isEmpty(mdmTerminalVo)){
            log.info("未获取到客户或经销商信息");
        }else if (ObjectUtils.isEmpty(mdmCustomerMsgRespVo)){
            sfaTerminalService.countAchievementAndIntegral(mdmTerminalVo, list.get(1));
        }else if (ObjectUtils.isEmpty(mdmTerminalVo)){
            sfaCustomerService.countAchievementAndIntegral(mdmCustomerMsgRespVo, list.get(1));
        }
    }

}
