package com.biz.crm.achievement.mapper;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.biz.crm.achievement.model.SfaAchievementAccomplishRecordEntity;
import com.biz.crm.nebular.sfa.achievement.resp.SfaAchievementTimeTotalRespVo;
import com.biz.crm.nebular.sfa.visitinfo.resp.SfaVisitAndSalesTrendChartRespVo;
import com.biz.crm.nebular.sfa.visitinfo.resp.SfaVisitRankingDetailedRespVo;
import org.apache.ibatis.annotations.Param;

import java.math.BigDecimal;
import java.util.List;

/**
 * @author yangshan
 * @date 2021-3-1 09:55:25
 */
public interface SfaAchievementAccomplishRecordMapper extends BaseMapper<SfaAchievementAccomplishRecordEntity> {

    /**
     * 根据指标编码查询对应月份 实际完成次数
     * @param posCode
     * @param indexCode
     * @param monthsList
     * @return
     */
    List<SfaAchievementTimeTotalRespVo> findAccomplishNumByYm(@Param("posCode")String posCode, @Param("indexCode") String indexCode,
                                                                  @Param("list") List<String> monthsList);

    /**
     * 多职位 查询指标某段时间内的实际完成数
     * @param indexCode
     * @param posCodeList
     * @param startDate
     * @param endDate
     * @return
     */
    List<SfaAchievementTimeTotalRespVo> findPosCodeListAccomplishNum(@Param("list")List<String> posCodeList, @Param("indexCode") String indexCode,
                                                                         @Param("startDate")String startDate, @Param("endDate")String endDate);

    /**
     * 查询当前时间段被拜访过的客户数
     * @param posCode
     * @param startDate
     * @param endDate
     * @return
     */
    BigDecimal findVisitCustNumber(@Param("posCode")String posCode, @Param("startDate")String startDate, @Param("endDate")String endDate);
}
