package com.biz.crm.achievement.model;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.base.CrmExtTenEntity;
import com.biz.crm.sqlupdate.CrmColumn;
import com.biz.crm.sqlupdate.CrmTable;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;
import lombok.experimental.Accessors;
import org.springframework.data.elasticsearch.annotations.Field;
import org.springframework.data.elasticsearch.annotations.FieldType;

/**
 * @author yangshan
 * @date 2021-3-1 09:56:34
 */
@Getter
@Setter
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@TableName("sfa_achievement_accomplish_record")
@CrmTable(name = "sfa_achievement_accomplish_record")
public class SfaAchievementAccomplishRecordEntity extends CrmExtTenEntity<SfaAchievementAccomplishRecordEntity> {

    /**
     * 创建人username
     */
    @CrmColumn(name = "username", length = 40)
    private String username;

    /**
     * 创建人职位编码
     */
    @CrmColumn(name = "object_pos_code", length = 40)
    private String objectPosCode;

    /**
     * 指标编码
     */
    @CrmColumn(name = "index_code", length = 40)
    private String indexCode;

    /**
     * 组织编码集合
     */
    @CrmColumn(name = "create_org_code_list", length = 200)
    private String createOrgCodeList;

    /**
     * 客户编码
     */
    @CrmColumn(name = "customer_code", length = 40)
    private String customerCode;

    /**
     * 关联Id
     */
    @CrmColumn(name = "relation_id", length = 40)
    private String relationId;

    /**
     * 创建时间
     */
    @CrmColumn(name = "create_time", length = 60)
    private String createTime;

    @CrmColumn(name = "create_year_month", length = 40,note = "年月")
    private String createYearMonth;

    /**
     * 拜访类型;拜访类型(临时拜访/计划拜访)(拜访查询用！)
     */
    @CrmColumn(name = "visit_type", length = 32, note = "拜访类型;拜访类型(temporary:临时拜访/plan:计划拜访)")
    private String visitType;

    /**
     * 拜访大类(拜访查询用！)
     */
    @CrmColumn(name = "visit_big_type", length = 32, note = "拜访大类（VISIT:拜访，HELP_VISIT:协访，UNFAMILIAR_VISIT:陌拜）")
    private String visitBigType;
}
