package com.biz.crm.achievement.model;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.base.CrmExtTenEntity;
import com.biz.crm.sqlupdate.CrmColumn;
import com.biz.crm.sqlupdate.CrmTable;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;
import lombok.experimental.Accessors;

import javax.persistence.Index;

/**
 * @author yangshan
 * @date 2021-2-25 12:56:27
 */
@Getter
@Setter
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@TableName("sfa_achievement_rule")
@CrmTable(name = "sfa_achievement_rule", indexes = {
        @Index(name = "sfa_achievement_rule_index1", columnList = "object_pos_code, achievement_date, index_code"),
        @Index(name = "sfa_achievement_rule_index2", columnList = "object_code,achievement_date, achievement_object_type, index_code")
})
public class SfaAchievementRuleEntity extends CrmExtTenEntity<SfaAchievementRuleEntity> {
    public static final String OBJECT_POS_CODE_DEF = "-10000";

    /**
     * 对象编码
     */
    @CrmColumn(name = "object_code", length = 100,note = "对象编码")
    private String objectCode;
    /**
     * 对象名称
     */
    @CrmColumn(name = "object_name", length = 100,note = "对象名称")
    private String objectName;

    /**
     * 对象类型
     */
    @CrmColumn(name = "achievement_object_type", length = 100,note = "绩效对象类型")
    private String achievementObjectType;

    /**
     * 职位编码
     */
    @CrmColumn(name = "object_pos_code", length = 100,note = "职位编码")
    private String objectPosCode;
    /**
     * 职位名称
     */
    @CrmColumn(name = "object_pos_name", length = 100,note = "职位名称")
    private String objectPosName;

    /**
     * 对象组织编码
     */
    @CrmColumn(name = "object_org_code", length = 100,note = "对象组织编码")
    private String objectOrgCode;
    /**
     * 对象组织名称
     */
    @CrmColumn(name = "object_org_name", length = 100,note = "对象组织名称")
    private String objectOrgName;


    /**
     * 绩效时间
     */
    @CrmColumn(name = "achievement_date", length = 100,note = "绩效时间")
    private String achievementDate;

    /**
     * 绩效类型
     */
    @CrmColumn(name = "achievement_type", length = 100,note = "绩效类型")
    private String achievementType;

    /**
     * 指标编码
     */
    @CrmColumn(name = "index_code", length = 100,note = "指标编码")
    private String indexCode;

    /**
     * 指标名称
     */
    @CrmColumn(name = "index_name", length = 100,note = "指标名称")
    private String indexName;

    /**
     * 权重
     */
    @CrmColumn(name = "weight", length = 100,note = "权重")
    private String weight;

    /**
     * 目标数量
     */
    @CrmColumn(name = "target_num", length = 100,note = "目标数量")
    private String targetNum;

    /**
     * 单位
     */
    @CrmColumn(name = "unit", length = 100,note = "单位")
    private String unit;

    /**
     * 开始时间（用于查询记录）
     */
    @CrmColumn(name = "begin_date", length = 100,note = "开始时间")
    private String beginDate;

    /**
     * 结束时间（用于查询记录）
     */
    @CrmColumn(name = "end_date", length = 100,note = "结束时间")
    private String endDate;
}
