package com.biz.crm.achievement.service;

import com.baomidou.mybatisplus.extension.service.IService;
import com.biz.crm.achievement.model.SfaAchievementAccomplishRecordEntity;
import com.biz.crm.nebular.sfa.achievement.req.SfaAchievementAccomplishRecordReqVo;
import com.biz.crm.nebular.sfa.achievement.resp.SfaAchievementTimeTotalRespVo;
import org.apache.ibatis.annotations.Param;

import java.util.List;


/**
 * @author yangshan
 * @date 2021-3-1 11:24:23
 */
public interface ISfaAchievementAccomplishRecordService extends IService<SfaAchievementAccomplishRecordEntity> {

    /**
     * 新增
     * @param reqVo
     */
    void save(List<SfaAchievementAccomplishRecordReqVo> reqVo);

    /**
     * 新增
     * @param reqVo
     */
    void save(SfaAchievementAccomplishRecordReqVo reqVo);

    /**
     * 删除
     * @param relationId
     */
    void delete(String relationId);

    /**
     * 根据关联id修改删除状态
     * @param relationId
     */
    void updateDeleteStateByRelationId(String relationId);

    /**
     * 根据指标编码查询对应月份 实际完成次数
     * @param posCode
     * @param indexCode
     * @return
     */
    List<SfaAchievementTimeTotalRespVo> findAccomplishNumByYm(String posCode, String indexCode);

    /**
     * 多职位 查询指标某段时间内的实际完成数
     * @param indexCode
     * @param posCodeList
     * @param startDate
     * @param endDate
     * @return
     */
    List<SfaAchievementTimeTotalRespVo> findPosCodeListAccomplishNum(List<String> posCodeList, String indexCode,
                                                                     String startDate, String endDate);

    /**
     * 逻辑删除
     * @param relationId
     */
    void deleteByRelationId(String relationId);

    /**
     * 启用
     * @param relationId
     */
    void reuseByRelationId(String relationId);
}
