package com.biz.crm.achievement.service;

import com.biz.crm.common.PageResult;
import com.biz.crm.nebular.sfa.achievement.req.SfaAchievementRuleReqVo;
import com.biz.crm.nebular.sfa.achievement.req.SfaAchievementRuleTableReqVo;
import com.biz.crm.nebular.sfa.achievement.resp.SfaAchievementRuleTableRespVo;

import java.util.List;

/**
 * @author yangshan
 * @date 2021-2-25 12:56:27
 */
public interface ISfaAchievementRuleService {
    /**
     * 列表
     * @param reqVo
     * @return
     */
    PageResult<SfaAchievementRuleTableRespVo> findList(SfaAchievementRuleTableReqVo reqVo);

    /**
     * 新增
     * @param reqVo
     */
    void save(SfaAchievementRuleReqVo reqVo);

    /**
     * 删除
     * @param ids
     */
    void deleteBatch(List<String> ids);

    /**
     * 小程序列表（本月）
     * @param timeType
     * @param objectCode
     * @param objectPosCode
     * @return
     */
    List<SfaAchievementRuleTableRespVo> miniListThisMonth(String timeType, String objectCode, String objectPosCode);
}
