package com.biz.crm.achievement.service;

import com.biz.crm.common.PageResult;
import com.biz.crm.nebular.sfa.achievement.req.SfaIndexReqVo;
import com.biz.crm.nebular.sfa.achievement.resp.SfaIndexRespVo;

import java.util.List;

/**
 * @author yangshan
 * @date 2021-2-23 19:43:41
 */
public interface ISfaIndexService {
    /**
     * 列表
     * @param sfaIndexReqVo
     * @return
     */
    PageResult<SfaIndexRespVo> findList(SfaIndexReqVo sfaIndexReqVo);

    /**
     * 新增
     * @param sfaIndexReqVo
     */
    void save(SfaIndexReqVo sfaIndexReqVo);

    /**
     * 更新
     * @param sfaIndexReqVo
     */
    void update(SfaIndexReqVo sfaIndexReqVo);

    /**
     * 删除
     * @param ids
     */
    void deleteBatch(List<String> ids);

    /**
     * 启用
     * @param ids
     */
    void enableBatch(List<String> ids);

    /**
     * 禁用
     * @param ids
     */
    void disableBatch(List<String> ids);
}
