package com.biz.crm.achievement.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.achievement.mapper.SfaAchievementAccomplishRecordMapper;
import com.biz.crm.achievement.model.SfaAchievementAccomplishRecordEntity;
import com.biz.crm.achievement.service.ISfaAchievementAccomplishRecordService;
import com.biz.crm.base.BusinessException;
import com.biz.crm.eunm.CrmDelFlagEnum;
import com.biz.crm.nebular.mdm.org.resp.MdmOrgRespVo;
import com.biz.crm.nebular.sfa.achievement.req.SfaAchievementAccomplishRecordReqVo;
import com.biz.crm.nebular.sfa.achievement.resp.SfaAchievementTimeTotalRespVo;
import com.biz.crm.util.*;
import jodd.util.ObjectUtil;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.ObjectUtils;

import java.time.LocalDateTime;
import java.util.List;
import java.util.stream.Collectors;

/**
 * @author yangshan
 * @date 2021-3-1 11:25:01
 */
@Service
@ConditionalOnMissingBean(name = "sfaAchievementAccomplishRecordServiceExpendImpl")
public class SfaAchievementAccomplishRecordServiceImpl<M extends BaseMapper<T>,T> extends ServiceImpl<SfaAchievementAccomplishRecordMapper, SfaAchievementAccomplishRecordEntity> implements ISfaAchievementAccomplishRecordService {

    @Autowired
    private SfaAchievementAccomplishRecordMapper achievementAccomplishRecordMapper;
    /**
     * 新增
     * @param reqVo
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void save(List<SfaAchievementAccomplishRecordReqVo> reqVo) {
        if (CollectionUtil.listEmpty(reqVo)){
            throw new BusinessException("数据为空");
        }
        String createOrgCodeList = "";
        UserRedis user = UserUtils.getUser();
        if (StringUtils.isNotEmpty(user.getOrgcode())){
            List<MdmOrgRespVo> orgList = OrgUtil.getParentOrgListIncludeSelf(user.getOrgcode());
            if (CollectionUtil.listNotEmpty(orgList)){
                createOrgCodeList = orgList.stream().map(MdmOrgRespVo::getOrgCode).collect(Collectors.joining(","));
            }
        }
        String finalCreateOrgCodeList = createOrgCodeList;
        reqVo.forEach(o ->{
            if (StringUtils.isEmpty(o.getCreateOrgCodeList())){
                o.setCreateOrgCodeList(finalCreateOrgCodeList);
            }
        });

        for (SfaAchievementAccomplishRecordReqVo recordReqVo : reqVo){
            AssertUtils.isNotEmpty(recordReqVo.getIndexCode(),"指标编码不能为空");
            recordReqVo.setCreateOrgCodeList(recordReqVo.getCreateOrgCodeList());
            AssertUtils.isNotEmpty(recordReqVo.getCreateOrgCodeList(), "组织编码不能为空");
            AssertUtils.isNotEmpty(recordReqVo.getCustomerCode(), "客户编码不能为空");
            if (StringUtils.isEmpty(recordReqVo.getCreateTime())){
                recordReqVo.setCreateTime(LocalDateTime.now().format(CrmDateUtils.yyyyMMddHHmmss));
                recordReqVo.setCreateYearMonth(LocalDateTime.now().format(CrmDateUtils.yyyyMM));
            }
        }
        //根据relationId去重
        List<SfaAchievementAccomplishRecordEntity> entities = CrmBeanUtil.copyList(reqVo, SfaAchievementAccomplishRecordEntity.class);
        List<String> relationIdList = entities.stream().map(SfaAchievementAccomplishRecordEntity::getRelationId).collect(Collectors.toList());
        List<SfaAchievementAccomplishRecordEntity> sfaAchievementAccomplishRecordEntity = this.achievementAccomplishRecordMapper.selectList(Wrappers.lambdaQuery(SfaAchievementAccomplishRecordEntity.class)
                .in(SfaAchievementAccomplishRecordEntity::getRelationId, relationIdList));
        if (CollectionUtil.listNotEmpty(sfaAchievementAccomplishRecordEntity)){
            List<String> relationIds = sfaAchievementAccomplishRecordEntity.stream().map(SfaAchievementAccomplishRecordEntity::getRelationId).collect(Collectors.toList());
            this.achievementAccomplishRecordMapper.delete(lambdaQuery().in(SfaAchievementAccomplishRecordEntity::getRelationId, relationIds));
        }
        this.saveBatch(entities);
    }

    /**
     * 删除
     * @param relationId
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void delete(String relationId) {
        QueryWrapper<SfaAchievementAccomplishRecordEntity> queryWrapper = new QueryWrapper<>();
        queryWrapper.eq("relation_id", relationId);
        achievementAccomplishRecordMapper.delete(queryWrapper);
    }

    /**
     * 根据关联id修改删除状态
     * @param relationId
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void updateDeleteStateByRelationId(String relationId) {
        AssertUtils.isNotEmpty(relationId, "关联id不能为空");
        QueryWrapper<SfaAchievementAccomplishRecordEntity> queryWrapper = new QueryWrapper<>();
        queryWrapper.eq("relation_id", relationId);
        SfaAchievementAccomplishRecordEntity entity = achievementAccomplishRecordMapper.selectOne(queryWrapper);
        if (!ObjectUtils.isEmpty(entity)){
            if (CrmDelFlagEnum.NORMAL.getCode().equals(entity.getDelFlag())){
                entity.setDelFlag(CrmDelFlagEnum.DELETE.getCode());
            }
            if (CrmDelFlagEnum.DELETE.getCode().equals(entity.getDelFlag())){
                entity.setDelFlag(CrmDelFlagEnum.NORMAL.getCode());
            }
        }
        achievementAccomplishRecordMapper.updateById(entity);
    }

    /**
     * 根据指标编码查询对应月份 实际完成次数
     */
    @Override
    public List<SfaAchievementTimeTotalRespVo> findAccomplishNumByYm(String posCode, String indexCode) {
        return null;
    }

    /**
     * 多职位 查询指标某段时间内的实际完成数
     */
    @Override
    public List<SfaAchievementTimeTotalRespVo> findPosCodeListAccomplishNum(List<String> posCodeList, String indexCode, String startDate, String endDate) {
        return null;
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void save(SfaAchievementAccomplishRecordReqVo reqVo) {
        if(StringUtils.isEmpty(reqVo.getObjectPosCode())){
            return;
        }
        AssertUtils.isNotEmpty(reqVo.getIndexCode(),"指标编码不能为空");
        AssertUtils.isNotEmpty(reqVo.getUsername(),"创建人username不能为空");
        AssertUtils.isNotEmpty(reqVo.getObjectPosCode(),"创建人职位编码不能为空");
        AssertUtils.isNotEmpty(reqVo.getCreateOrgCodeList(),"组织编码不能为空");
        AssertUtils.isNotEmpty(reqVo.getCustomerCode(), "客户编码不能为空");
        AssertUtils.isNotEmpty(reqVo.getRelationId(), "关联id不能为空");

        if (StringUtils.isEmpty(reqVo.getCreateTime())){
            reqVo.setCreateTime(LocalDateTime.now().format(CrmDateUtils.yyyyMMddHHmmss));
            reqVo.setCreateYearMonth(LocalDateTime.now().format(CrmDateUtils.yyyyMM));
        }
        //根据relationId去重
        List<SfaAchievementAccomplishRecordEntity> entities = this.achievementAccomplishRecordMapper.selectList(Wrappers.lambdaQuery(SfaAchievementAccomplishRecordEntity.class)
                .eq(SfaAchievementAccomplishRecordEntity::getRelationId, reqVo.getRelationId()));
        if (CollectionUtil.listNotEmpty(entities)){
            this.achievementAccomplishRecordMapper.deleteBatchIds(entities.stream().map(SfaAchievementAccomplishRecordEntity::getId).collect(Collectors.toList()));
        }
        this.save(CrmBeanUtil.copy(reqVo, SfaAchievementAccomplishRecordEntity.class));
    }
    /**
     * 逻辑删除
     *
     * @param relationId
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void deleteByRelationId(String relationId) {
        AssertUtils.isNotEmpty(relationId, "关联id不能为空");
        this.lambdaUpdate().eq(SfaAchievementAccomplishRecordEntity::getRelationId, relationId)
                .set(SfaAchievementAccomplishRecordEntity::getDelFlag, CrmDelFlagEnum.DELETE.getCode())
                .update();
    }

    /**
     * 启用
     *
     * @param relationId
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void reuseByRelationId(String relationId) {
        AssertUtils.isNotEmpty(relationId, "关联id不能为空");
        this.lambdaUpdate().eq(SfaAchievementAccomplishRecordEntity::getRelationId, relationId)
                .set(SfaAchievementAccomplishRecordEntity::getDelFlag, CrmDelFlagEnum.NORMAL.getCode())
                .update();
    }
}
