package com.biz.crm.achievement.service.impl;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.achievement.mapper.SfaAchievementRuleMapper;
import com.biz.crm.achievement.model.SfaAchievementAccomplishRecordEntity;
import com.biz.crm.achievement.model.SfaAchievementRuleEntity;
import com.biz.crm.achievement.service.ISfaAchievementAccomplishRecordService;
import com.biz.crm.achievement.service.ISfaAchievementRuleService;
import com.biz.crm.base.BusinessException;
import com.biz.crm.common.PageResult;
import com.biz.crm.eunm.CrmDelFlagEnum;
import com.biz.crm.eunm.CrmEnableStatusEnum;
import com.biz.crm.eunm.sfa.SfaVisitEnum;
import com.biz.crm.eunm.sfa.WorkSignEnum;
import com.biz.crm.nebular.mdm.position.resp.MdmPositionRespVo;
import com.biz.crm.nebular.sfa.achievement.req.SfaAchievementRuleObjectReqVo;
import com.biz.crm.nebular.sfa.achievement.req.SfaAchievementRuleReqVo;
import com.biz.crm.nebular.sfa.achievement.req.SfaAchievementRuleTableReqVo;
import com.biz.crm.nebular.sfa.achievement.req.SfaIndexRuleReqVo;
import com.biz.crm.nebular.sfa.achievement.resp.SfaAchievementRuleTableRespVo;
import com.biz.crm.util.*;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.ObjectUtils;

import javax.annotation.Resource;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.util.*;
import java.util.stream.Collectors;

/**
 * @author yangshan
 * @date 2021-2-25 14:06:15
 */
@Slf4j
@Service
@Transactional
@ConditionalOnMissingBean(name = "sfaAchievementRuleServiceExpendImpl")
public class SfaAchievementRuleServiceImpl<M extends BaseMapper<T>,T> extends ServiceImpl<SfaAchievementRuleMapper, SfaAchievementRuleEntity> implements ISfaAchievementRuleService {

    @Resource
    private SfaAchievementRuleMapper sfaAchievementRuleMapper;
    @Resource
    private ISfaAchievementAccomplishRecordService sfaAchievementAccomplishRecordService;

    /**
     * 列表
     * @param reqVo
     * @return
     */
    @Override
    public PageResult<SfaAchievementRuleTableRespVo> findList(SfaAchievementRuleTableReqVo reqVo) {
        //拜访绩效时，默认查询拜访
        if (StringUtils.isEmpty(reqVo.getVisitBigType())){
            reqVo.setVisitBigType(SfaVisitEnum.VisitBigType.VISIT.getVal());
        }
        Page<SfaAchievementRuleTableRespVo> page = new Page<>(reqVo.getPageNum(), reqVo.getPageSize());
        List<SfaAchievementRuleTableRespVo> list = sfaAchievementRuleMapper.findList(page, reqVo);
        this.setStatus(list);
        return PageResult.<SfaAchievementRuleTableRespVo>builder()
                .count(page.getTotal())
                .data(this.doCheckIndex(list, reqVo.getVisitBigType()))
                .build();
    }

    /**
     * 新增
     * @param reqVo
     * @return
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void save(SfaAchievementRuleReqVo reqVo) {
        if(ObjectUtils.isEmpty(reqVo)){
            return;
        }
        //组装一条数据并设置字段值
        ArrayList<SfaAchievementRuleEntity> list = new ArrayList<>();
        for (SfaAchievementRuleObjectReqVo objectReqVo : reqVo.getObjectList()){

            SfaAchievementRuleTableReqVo ruleTableReqVo = CrmBeanUtil.copy(reqVo, SfaAchievementRuleTableReqVo.class);
            ruleTableReqVo.setObjectCode(objectReqVo.getObjectCode());
            ruleTableReqVo.setObjectName(objectReqVo.getObjectName());
            ruleTableReqVo.setObjectPosCode(objectReqVo.getObjectPosCode());
            ruleTableReqVo.setObjectPosName(objectReqVo.getObjectPosName());
            for(SfaIndexRuleReqVo indexRuleReqVo : reqVo.getIndexReqVos()){
                ruleTableReqVo.setIndexCode(indexRuleReqVo.getIndexCode());
                ruleTableReqVo.setIndexName(indexRuleReqVo.getIndexName());
                ruleTableReqVo.setWeight(indexRuleReqVo.getWeight());
                ruleTableReqVo.setTargetNum(indexRuleReqVo.getTargetNum());
                ruleTableReqVo.setUnit(indexRuleReqVo.getUnit());

                this.checkParam(ruleTableReqVo);
                if (!ruleTableReqVo.getAchievementDateYear().isEmpty()){
                    this.getDayOfDate(ruleTableReqVo);
                }
                SfaAchievementRuleEntity entity = CrmBeanUtil.copy(ruleTableReqVo, SfaAchievementRuleEntity.class);
                String objectOrgCode = null, objectOrgName = null;
                if(org.apache.commons.lang3.StringUtils.isNotBlank(entity.getObjectPosCode())){
                    entity.setAchievementObjectType(WorkSignEnum.AchievementObjectType.USER_POS.getVal());
                    MdmPositionRespVo positionRespVo = PositionUtil.getPositionByCode(entity.getObjectPosCode());
                    if(null != positionRespVo){
                        objectOrgCode = positionRespVo.getOrgCode();
                        objectOrgName = positionRespVo.getOrgName();
                    }
                }else{
                    objectOrgCode = entity.getObjectCode();
                    objectOrgName = entity.getObjectName();
                    entity.setObjectPosCode(SfaAchievementRuleEntity.OBJECT_POS_CODE_DEF);
                    entity.setAchievementObjectType(WorkSignEnum.AchievementObjectType.ORG.getVal());
                }
                entity.setObjectOrgCode(objectOrgCode);
                entity.setObjectOrgName(objectOrgName);
                list.add(entity);
            }
        }

        //去重，比对每个字段
        Map<String, List<SfaAchievementRuleEntity>> collect = list.stream().distinct().collect(Collectors.groupingBy(o -> o.getObjectPosCode() + "-" + o.getAchievementDate()));
        List<SfaAchievementRuleEntity> data = collect.values().stream().flatMap(Collection::stream).collect(Collectors.toList());
        if (list.size() > data.size()){
            throw new BusinessException("数据重复");
        }
        //校验绩效规则合计
        collect.keySet().forEach(s -> {
            if (CollectionUtil.listNotEmpty(collect.get(s))){
                BigDecimal w = collect.get(s).stream().map(SfaAchievementRuleEntity::getWeight).map(BigDecimal::new).reduce(BigDecimal.ZERO, BigDecimal::add);
                boolean one = w.compareTo(BigDecimal.ONE) == 0;
                boolean zero = w.compareTo(BigDecimal.ZERO) == 0;
                if (!one && !zero){
                    collect.remove(s);
                    throw new BusinessException("权重合计不为100%");
                }
            }
        });

        data = collect.values().stream().flatMap(Collection::stream).collect(Collectors.toList());
        if (CollectionUtil.listNotEmpty(data)){
            data.forEach(o -> {

                this.sfaAchievementRuleMapper.delete(Wrappers.lambdaQuery(SfaAchievementRuleEntity.class)
                        .eq(SfaAchievementRuleEntity::getObjectCode, o.getObjectCode())
                        .eq(SfaAchievementRuleEntity::getObjectPosCode, o.getObjectPosCode())
                        .eq(SfaAchievementRuleEntity::getAchievementObjectType, o.getAchievementObjectType())
                        .eq(SfaAchievementRuleEntity::getAchievementDate, o.getAchievementDate())
                        .eq(SfaAchievementRuleEntity::getIndexCode, o.getIndexCode()));
            });
        }
        this.saveBatch(data);
    }

    /**
     * 设置开始时间和结束时间（主要是为查询绩效的实际完成数量）
     * @param reqVo
     * @return
     */
    public SfaAchievementRuleTableReqVo getDayOfDate(SfaAchievementRuleTableReqVo reqVo) {
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
        Calendar cale = Calendar.getInstance();
        // 获取该月第一天和最后一天
        String firstDay, lastDay;
        String s = reqVo.getAchievementDateYear() + "-" + reqVo.getAchievementDateMonth() + "-15";
        Date date = null;
        try {
            date = format.parse(s);
        } catch (Exception e) {
            throw new BusinessException("时间格式错误");
        }
        cale.setTime(date);
        // 获取月的第一天
        cale.add(Calendar.MONTH, 0);
        cale.set(Calendar.DAY_OF_MONTH, 1);
        firstDay = format.format(cale.getTime());
        // 获取月的最后一天
        cale.add(Calendar.MONTH, 1);
        cale.set(Calendar.DAY_OF_MONTH, 0);
        lastDay = format.format(cale.getTime());

        if (StringUtils.isNotEmpty(reqVo.getAchievementDateTenDays())){
            if (WorkSignEnum.achievementTimeType.SX.getVal().equals(reqVo.getAchievementDateTenDays())){
                lastDay = reqVo.getAchievementDateYear() + "-" + reqVo.getAchievementDateMonth() + "-15";
            }else {
                firstDay = reqVo.getAchievementDateYear() + "-" + reqVo.getAchievementDateMonth() + "-15";
            }
        }
        reqVo.setBeginDate(firstDay).setEndDate(lastDay);
        return reqVo;
    }

    /**
     * 参数校验
     * @param reqVo
     */
    public void checkParam(SfaAchievementRuleTableReqVo reqVo){
        AssertUtils.isNotEmpty(reqVo.getObjectCode(), "对象编码为空");
        AssertUtils.isNotEmpty(reqVo.getObjectName(), "对象名称为空");
        AssertUtils.isNotEmpty(reqVo.getAchievementType(), "绩效类型为空");
        //时间校验
        if (StringUtils.isNotEmpty(reqVo.getAchievementDateYear())){
            StringBuilder achievementDate = new StringBuilder().append(reqVo.getAchievementDateYear())
                    .append("年")
                    .append(reqVo.getAchievementDateMonth())
                    .append("月");
            if (StringUtils.isNotEmpty(reqVo.getAchievementDateTenDays())){
                if (reqVo.getAchievementDateTenDays().equals(WorkSignEnum.achievementTimeType.SX.getVal())){
                    achievementDate.append(WorkSignEnum.achievementTimeType.SX.getDesc());
                }
                if (reqVo.getAchievementDateTenDays().equals(WorkSignEnum.achievementTimeType.XX.getVal())){
                    achievementDate.append(WorkSignEnum.achievementTimeType.XX.getDesc());
                }
            }
            reqVo.setAchievementDate(achievementDate.toString());

        }
        if(reqVo.getAchievementType().equals(WorkSignEnum.achievementTimeType.FT.getVal())){
            LocalDate beginDate = null;
            try {
                beginDate = LocalDate.parse(reqVo.getBeginDate(), CrmDateUtils.yyyyMMdd);
            } catch (Exception e) {
                throw new BusinessException("有效开始时间格式错误");
            }
            LocalDate endDate = null;
            try {
                endDate = LocalDate.parse(reqVo.getEndDate(), CrmDateUtils.yyyyMMdd);
            } catch (Exception e) {
                throw new BusinessException("有效结束时间格式错误");
            }
            if (!(beginDate.isBefore(endDate))) {
                throw new BusinessException("有效开始时间不能大于有效结束时间");
            }
            reqVo.setAchievementDate(reqVo.getBeginDate() + "-" + reqVo.getEndDate());
        }
        AssertUtils.isNotEmpty(reqVo.getAchievementDate(), "绩效时间为空");
        AssertUtils.isNotEmpty(reqVo.getTargetNum(), "目标数量为空");
        AssertUtils.isNotEmpty(reqVo.getUnit(), "单位为空");
        AssertUtils.isNotEmpty(reqVo.getIndexCode(), "指标编码为空");
        AssertUtils.isNotEmpty(reqVo.getIndexName(), "指标名称为空");
    }

    /**
     * 删除
     * @param ids
     * @return
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void deleteBatch(List<String> ids) {
        List<SfaAchievementRuleEntity> sfaAchievementRuleEntities = sfaAchievementRuleMapper.selectBatchIds(ids);
        if (CollectionUtils.isNotEmpty(sfaAchievementRuleEntities)){
            sfaAchievementRuleEntities.forEach(o -> {
                o.setDelFlag(CrmDelFlagEnum.DELETE.getCode());
            });
        }
        this.updateBatchById(sfaAchievementRuleEntities);

    }

    /**
     * 小程序列表（本月,上月）
     */
    @Override
    public List<SfaAchievementRuleTableRespVo> miniListThisMonth(String timeType, String objectCode, String objectPosCode) {
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM");
        String date = format.format(new Date());
        //小程序列表（上月）
        if(timeType.equals(WorkSignEnum.TimeType.SY.getVal())){
            Calendar c = Calendar.getInstance();
            c.setTime(new Date());
            c.add(Calendar.MONTH, -1);
            date = format.format(c.getTime());
        }

        String[] s = date.split("-");
        SfaAchievementRuleTableReqVo reqVo = new SfaAchievementRuleTableReqVo();
        reqVo.setAchievementDate(s[0] + "年" + s[1] + "月");
        reqVo.setObjectCode(objectCode);
        reqVo.setObjectPosCode(objectPosCode);
        //拜访绩效时，默认查询拜访
        if (StringUtils.isEmpty(reqVo.getVisitBigType())){
            reqVo.setVisitBigType(SfaVisitEnum.VisitBigType.VISIT.getVal());
        }
        List<SfaAchievementRuleTableRespVo> list = sfaAchievementRuleMapper.miniList(reqVo);
        this.setStatus(list);
        return this.doCheckIndex(list, reqVo.getVisitBigType());

    }

    public void setStatus(List<SfaAchievementRuleTableRespVo> list){
        for(SfaAchievementRuleTableRespVo respVo : list){

            respVo.setEnableStatusName(CrmEnableStatusEnum.getDesc(respVo.getEnableStatus()));
            //根据时间类型编码设置时间类型名称
            if(WorkSignEnum.achievementTimeType.MM.getVal().equals(respVo.getAchievementType())){
                respVo.setAchievementTypeName(WorkSignEnum.achievementTimeType.MM.getDesc());
            }
            if(WorkSignEnum.achievementTimeType.TD.getVal().equals(respVo.getAchievementType())){
                respVo.setAchievementTypeName(WorkSignEnum.achievementTimeType.TD.getDesc());
            }
            if(WorkSignEnum.achievementTimeType.FT.getVal().equals(respVo.getAchievementType())){
                respVo.setAchievementTypeName(WorkSignEnum.achievementTimeType.FT.getDesc());
            }
        }
    }

    /**
     * 如果是拜访，处理实际拜访数
     */
    private List<SfaAchievementRuleTableRespVo> doCheckIndex(List<SfaAchievementRuleTableRespVo> respVos, String visitBigType){
        if (CollectionUtil.listNotEmpty(respVos)){
            respVos.forEach(o -> {
                if (o.getIndexCode().equals(SfaVisitEnum.indexType.WDBF.getCode())){
                    SfaAchievementRuleEntity entity = this.sfaAchievementRuleMapper.selectOne(Wrappers.lambdaQuery(SfaAchievementRuleEntity.class)
                            .eq(SfaAchievementRuleEntity::getIndexCode, o.getIndexCode())
                            .eq(SfaAchievementRuleEntity::getObjectCode, o.getObjectCode())
                            .eq(SfaAchievementRuleEntity::getAchievementDate, o.getAchievementDate()));
                    //查询计划中实际拜访数（拜访大类为visit）
                    BigDecimal planVisitNumber = BigDecimal.ZERO;
                    //组织
                    if (StringUtils.isEmpty(o.getObjectPosCode())){
                        //组织(取出当前绩效规则时间段内的拜访list)
                        List<SfaAchievementAccomplishRecordEntity> orgRecordList = this.sfaAchievementAccomplishRecordService.list(Wrappers.lambdaQuery(SfaAchievementAccomplishRecordEntity.class)
                                .eq(SfaAchievementAccomplishRecordEntity::getVisitBigType, visitBigType)
                                .between(SfaAchievementAccomplishRecordEntity::getCreateTime, entity.getBeginDate(), entity.getEndDate())
                                .like(SfaAchievementAccomplishRecordEntity::getCreateOrgCodeList, o.getObjectCode()));
                        if (CollectionUtil.listNotEmpty(orgRecordList)){

                            planVisitNumber = BigDecimal.valueOf(orgRecordList.size());
                        }
                    }else {
                        //员工
                        List<SfaAchievementAccomplishRecordEntity> posRecordList = this.sfaAchievementAccomplishRecordService.list(Wrappers.lambdaQuery(SfaAchievementAccomplishRecordEntity.class)
                                .eq(SfaAchievementAccomplishRecordEntity::getVisitBigType, SfaVisitEnum.VisitBigType.VISIT.getVal())
                                .eq(SfaAchievementAccomplishRecordEntity::getObjectPosCode, o.getObjectPosCode())
                                .between(SfaAchievementAccomplishRecordEntity::getCreateTime, entity.getBeginDate(), entity.getEndDate()));
                        if (CollectionUtil.listNotEmpty(posRecordList)){
                            planVisitNumber = BigDecimal.valueOf(posRecordList.size());
                        }
                    }
                    //实际完成数量
                    o.setAccomplishNum(planVisitNumber.toString());
                    //指标达成率
                    BigDecimal tar = new BigDecimal(o.getTargetNum());
                    BigDecimal divide = planVisitNumber.compareTo(BigDecimal.ZERO)>0?planVisitNumber.divide(tar, 2, BigDecimal.ROUND_HALF_UP)
                            .multiply(BigDecimal.valueOf(100)):BigDecimal.ZERO;
                    o.setAccomplishAchievementIndexRate(divide.toString());
                    //实际完成绩效指标率
                    BigDecimal w = new BigDecimal(o.getWeight());
                    if (!(planVisitNumber.compareTo(BigDecimal.ZERO)==0 || w.compareTo(BigDecimal.ZERO) == 0)){
                        o.setAccomplishIndexRate(divide.multiply(w).setScale(2, RoundingMode.HALF_UP).toString());
                    }
                }
            });
        }
        return respVos;
    }
}
