package com.biz.crm.activity.controller;

import com.biz.crm.activity.service.ISfaActivityExecutionService;
import com.biz.crm.aop.CrmLog;
import com.biz.crm.common.PageResult;
import com.biz.crm.nebular.sfa.activity.req.SfaActivityExecutionReqVo;
import com.biz.crm.nebular.sfa.activity.resp.SfaActivityExecutionRespVo;
import com.biz.crm.util.Result;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
 * 活动执行;
 *
 * @author lf
 * @date 2020-12-30 15:24:11
 */
@Slf4j
@RestController
@RequestMapping("/sfaActivityExecutionController")
@Api(tags = "活动执行;")
public class SfaActivityExecutionController {
    @Autowired
    private ISfaActivityExecutionService sfaActivityExecutionService;

    @ApiOperation(value = "活动执行明细解析")
    @PostMapping("/resolveSfaVisitStepActivityExecution")
    @CrmLog
    public Result resolveSfaVisitStepActivityExecution( @RequestParam(required = false, defaultValue = "false") Boolean compensation) {
        this.sfaActivityExecutionService.resolveSfaVisitStepActivityExecutionJob(compensation);
        return Result.ok();
    }

    /**
     * 列表
     */
    @ApiOperation(value = "查询列表")
    @PostMapping("/list")
    @CrmLog
    public Result<PageResult<SfaActivityExecutionRespVo>> list(@RequestBody SfaActivityExecutionReqVo sfaActivityExecutionReqVo) {
        PageResult<SfaActivityExecutionRespVo> result=sfaActivityExecutionService.findList(sfaActivityExecutionReqVo);
        return Result.ok(result);
    }


    /**
     * 通过id查询详情
     */
    @ApiOperation(value = "通过id查询详情")
    @GetMapping("/queryDetailById")
    @CrmLog
    public Result<SfaActivityExecutionRespVo> queryDetailById(@RequestParam String id) {
        SfaActivityExecutionRespVo respVo=sfaActivityExecutionService.queryDetailById(id);
        return Result.ok(respVo);
    }

    /**
     * 查询
     */
    @ApiOperation(value = "查询")
    @PostMapping("/query")
    @CrmLog
    public Result<SfaActivityExecutionRespVo> query(@RequestBody SfaActivityExecutionReqVo sfaActivityExecutionReqVo) {
        SfaActivityExecutionRespVo respVo=sfaActivityExecutionService.query(sfaActivityExecutionReqVo);
        return Result.ok(respVo);
    }

    /**
     * 新增
     */
    @ApiOperation(value = "新增")
    @PostMapping("/save")
    @CrmLog
    public Result save(@RequestBody SfaActivityExecutionReqVo sfaActivityExecutionReqVo) {
        sfaActivityExecutionService.save(sfaActivityExecutionReqVo);
        return Result.ok();
    }

    /**
     * 更新
     */
    @ApiOperation(value = "更新")
    @PostMapping("/update")
    @CrmLog
    public Result update(@RequestBody SfaActivityExecutionReqVo sfaActivityExecutionReqVo) {
        sfaActivityExecutionService.update(sfaActivityExecutionReqVo);
        return Result.ok("修改成功");
    }

    /**
     * 删除
     */
    @ApiOperation(value = "删除")
    @PostMapping("/delete")
    @CrmLog
    public Result delete(@RequestBody List<String> ids) {
        sfaActivityExecutionService.deleteBatch(ids);
        return Result.ok("删除成功");
    }

    /**
     * 启用
     */
    @ApiOperation(value = "启用")
    @PostMapping("/enable")
    @CrmLog
    public Result enable(@RequestBody List<String> ids) {
        sfaActivityExecutionService.enableBatch(ids);
        return Result.ok("启用成功");
    }

    /**
     * 禁用
     */
    @ApiOperation(value = "禁用")
    @PostMapping("/disable")
    @CrmLog
    public Result disable(@RequestBody List<String> ids) {
        sfaActivityExecutionService.disableBatch(ids);
        return Result.ok("禁用成功");
    }
}
