package com.biz.crm.activity.model;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.base.CrmExtTenEntity;
import com.biz.crm.sqlupdate.CrmColumn;
import com.biz.crm.sqlupdate.CrmTable;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;
import lombok.experimental.Accessors;

/**
 * 方案活动产品;实体类
 *
 * @author lf
 * @date 2020-12-30 15:24:11
 */
@Getter
@Setter
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@TableName("sfa_activity_bg_product")
@CrmTable(name = "sfa_activity_bg_product",tableNote = "方案活动产品")
public class SfaActivityBgProductEntity extends CrmExtTenEntity<SfaActivityBgProductEntity> {

    /**
     * 活动执行id
     */
    @CrmColumn(name = "activity_execution_id", length = 100,note = "活动执行id")
    private String activityExecutionId;

    /**
     * 套餐Id
     */
    @CrmColumn(name = "setmeal_id", length = 100,note = "套餐Id")
    private String setmealId;

    /**
     * 产品编码
     */
    @CrmColumn(name = "product_code", length = 100,note = "产品编码")
    private String productCode;

    /**
     * 产品名称
     */
    @CrmColumn(name = "product_name", length = 100,note = "产品名称")
    private String productName;

    /**
     * 系列名称
     */
    @CrmColumn(name = "series_name", length = 100,note = "系列名称")
    private String seriesName;

    /**
     * 系列编码
     */
    @CrmColumn(name = "series_code", length = 100,note = "系列编码")
    private String seriesCode;

    /**
     * 行类型(1-本品,2-赠品)
     */
    @CrmColumn(name = "itme_type", length = 100,note = "行类型(1-本品,2-赠品)")
    private String itmeType;

}
