package com.biz.crm.activity.model;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.base.CrmExtTenEntity;
import com.biz.crm.sqlupdate.CrmColumn;
import com.biz.crm.sqlupdate.CrmTable;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;
import lombok.experimental.Accessors;

import javax.persistence.Index;

/**
 * 活动执行范围;实体类
 *
 * @author lf
 * @date 2020-12-30 15:24:11
 */
@Getter
@Setter
@TableName(SfaActivityRangeEntity.TABLE_NAME)
@CrmTable(name = SfaActivityRangeEntity.TABLE_NAME,tableNote = "活动执行范围", indexes = {
        @Index(name = SfaActivityRangeEntity.TABLE_NAME + "_index1", columnList = "activity_execution_id")})
public class SfaActivityRangeEntity extends CrmExtTenEntity<SfaActivityRangeEntity> {
    public static final String TABLE_NAME = "sfa_activity_range";
    /**
     * 活动执行id
     */
    @CrmColumn(name = "activity_execution_id", length = 100,note = "产品编码")
    private String activityExecutionId;

    /**
     * 范围类型(0-组织,1-渠道,2-客户)
     */
    @CrmColumn(name = "range_type", length = 100,note = "范围类型")
    private String rangeType;

    /**
     * 编码
     */
    @CrmColumn(name = "code", length = 100,note = "编码")
    private String code;

    /**
     * 名称
     */
    @CrmColumn(name = "name", length = 100,note = "名称")
    private String name;

}
