package com.biz.crm.activity.req;

import com.google.common.collect.Sets;
import lombok.AccessLevel;
import lombok.Data;
import lombok.Getter;
import lombok.Setter;

import java.util.Set;


/**
 * 活动执行明细解析上下文数据
 *  @author: luoqi
 *  @Date: 2021-4-26 11:47
 *  @version: V1.0
 *  @Description:
 */
@Data
public class ActivityExecutionResolveContext {
    //已解析的客户(终端)
    @Getter(AccessLevel.NONE)
    @Setter(AccessLevel.NONE)
    private Set<String> costActResolved = Sets.newHashSet();

    /**
     * 给定的费用活动是否已经解析过
     * @param costActCode
     * @return
     */
    public boolean costActResolved(String costActCode){
        if(this.costActResolved.contains(costActCode)){
            return true;
        }
        this.costActResolved.add(costActCode);
        return false;
    }


    //某一天的上下文
    private DayContext dayContext;



    @Data
    public static class DayContext{
        //已解析的客户(终端)
        @Getter(AccessLevel.NONE)
        @Setter(AccessLevel.NONE)
        private Set<String> clientCodesOfSend = Sets.newHashSet();

        public boolean needSend(String clientCode){
            if(this.clientCodesOfSend.contains(clientCode)){
                return false;
            }
            this.clientCodesOfSend.add(clientCode);
            return true;
        }


        //解析数据
        private ActivityExecutionResolveData resolveData;
    }
}
