package com.biz.crm.activity.service;

import com.baomidou.mybatisplus.extension.service.IService;
import com.biz.crm.activity.model.SfaActivityExecutionEntity;
import com.biz.crm.common.PageResult;
import com.biz.crm.nebular.sfa.activity.req.SfaActivityExecutionReqVo;
import com.biz.crm.nebular.sfa.activity.resp.SfaActivityExecutionRespVo;

import java.util.List;

/**
 * 活动执行;接口
 *
 * @author lf
 * @date 2020-12-30 15:24:11
 */
public interface ISfaActivityExecutionService extends IService<SfaActivityExecutionEntity> {

    /**
     * 列表
     * @param sfaActivityExecutionReqVo
     * @return PageResult<SfaActivityExecutionRespVo>
     */
    PageResult<SfaActivityExecutionRespVo> findList(SfaActivityExecutionReqVo sfaActivityExecutionReqVo);

    /**
     * 通过id查询详情
     * @param id
     * @return
     */
    SfaActivityExecutionRespVo queryDetailById(String id);

    /**
     * 查询
     * @param sfaActivityExecutionReqVo
     * @return SfaActivityExecutionRespVo
     */
    SfaActivityExecutionRespVo query(SfaActivityExecutionReqVo sfaActivityExecutionReqVo);

    /**
     * 新增
     * @param sfaActivityExecutionReqVo
     * @return
     */
    void save(SfaActivityExecutionReqVo sfaActivityExecutionReqVo);

    /**
     * 更新
     * @param sfaActivityExecutionReqVo
     * @return
     */
    void update(SfaActivityExecutionReqVo sfaActivityExecutionReqVo);

    /**
     * 删除
     * @param ids
     * @return
     */
    void deleteBatch(List<String> ids);

    /**
     * 启用
     * @param ids
     * @return
     */
    void enableBatch(List<String> ids);

    /**
     * 禁用
     * @param ids
     * @return
     */
    void disableBatch(List<String> ids);


    /**
     * 活动执行明细解析
     */
    void resolveSfaVisitStepActivityExecution(Boolean compensation);
    void resolveSfaVisitStepActivityExecutionJob(Boolean compensation);
}

