package com.biz.crm.activity.service;

import com.baomidou.mybatisplus.extension.service.IService;
import com.biz.crm.activity.model.SfaActivityProductEntity;
import com.biz.crm.common.PageResult;
import com.biz.crm.nebular.sfa.activity.req.SfaActivityProductReqVo;
import com.biz.crm.nebular.sfa.activity.resp.SfaActivityProductRespVo;

/**
 * 活动产品;接口
 *
 * @author lf
 * @date 2020-12-30 15:24:11
 */
public interface ISfaActivityProductService extends IService<SfaActivityProductEntity> {

    /**
     * 列表
     * @param sfaActivityProductReqVo
     * @return PageResult<SfaActivityProductRespVo>
     */
    PageResult<SfaActivityProductRespVo> findList(SfaActivityProductReqVo sfaActivityProductReqVo);

    /**
     * 查询
     * @param sfaActivityProductReqVo
     * @return SfaActivityProductRespVo
     */
    SfaActivityProductRespVo query(SfaActivityProductReqVo sfaActivityProductReqVo);

    /**
     * 新增
     * @param sfaActivityProductReqVo
     * @return
     */
    void save(SfaActivityProductReqVo sfaActivityProductReqVo);

    /**
     * 更新
     * @param sfaActivityProductReqVo
     * @return
     */
    void update(SfaActivityProductReqVo sfaActivityProductReqVo);

    /**
     * 删除
     * @param sfaActivityProductReqVo
     * @return
     */
    void deleteBatch(SfaActivityProductReqVo sfaActivityProductReqVo);

    /**
     * 启用
     * @param sfaActivityProductReqVo
     * @return
     */
    void enableBatch(SfaActivityProductReqVo sfaActivityProductReqVo);

    /**
     * 禁用
     * @param sfaActivityProductReqVo
     * @return
     */
    void disableBatch(SfaActivityProductReqVo sfaActivityProductReqVo);
}

